/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.UpdateAuthTokenDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateAuthTokenRequest
extends BmcRequest {
    private String userId;
    private String authTokenId;
    private UpdateAuthTokenDetails updateAuthTokenDetails;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "authTokenId", "updateAuthTokenDetails", "ifMatch"})
    UpdateAuthTokenRequest(String userId, String authTokenId, UpdateAuthTokenDetails updateAuthTokenDetails, String ifMatch) {
        this.userId = userId;
        this.authTokenId = authTokenId;
        this.updateAuthTokenDetails = updateAuthTokenDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAuthTokenId() {
        return this.authTokenId;
    }

    public UpdateAuthTokenDetails getUpdateAuthTokenDetails() {
        return this.updateAuthTokenDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userId;
        private String authTokenId;
        private UpdateAuthTokenDetails updateAuthTokenDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAuthTokenRequest o) {
            this.userId(o.getUserId());
            this.authTokenId(o.getAuthTokenId());
            this.updateAuthTokenDetails(o.getUpdateAuthTokenDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAuthTokenRequest build() {
            UpdateAuthTokenRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder authTokenId(String authTokenId) {
            this.authTokenId = authTokenId;
            return this;
        }

        public Builder updateAuthTokenDetails(UpdateAuthTokenDetails updateAuthTokenDetails) {
            this.updateAuthTokenDetails = updateAuthTokenDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateAuthTokenRequest buildWithoutInvocationCallback() {
            return new UpdateAuthTokenRequest(this.userId, this.authTokenId, this.updateAuthTokenDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateAuthTokenRequest.Builder(userId=" + this.userId + ", authTokenId=" + this.authTokenId + ", updateAuthTokenDetails=" + this.updateAuthTokenDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

