/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.UpdateIdentityProviderDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateIdentityProviderRequest
extends BmcRequest {
    private String identityProviderId;
    private UpdateIdentityProviderDetails updateIdentityProviderDetails;
    private String ifMatch;

    @ConstructorProperties(value={"identityProviderId", "updateIdentityProviderDetails", "ifMatch"})
    UpdateIdentityProviderRequest(String identityProviderId, UpdateIdentityProviderDetails updateIdentityProviderDetails, String ifMatch) {
        this.identityProviderId = identityProviderId;
        this.updateIdentityProviderDetails = updateIdentityProviderDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public UpdateIdentityProviderDetails getUpdateIdentityProviderDetails() {
        return this.updateIdentityProviderDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String identityProviderId;
        private UpdateIdentityProviderDetails updateIdentityProviderDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateIdentityProviderRequest o) {
            this.identityProviderId(o.getIdentityProviderId());
            this.updateIdentityProviderDetails(o.getUpdateIdentityProviderDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateIdentityProviderRequest build() {
            UpdateIdentityProviderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            return this;
        }

        public Builder updateIdentityProviderDetails(UpdateIdentityProviderDetails updateIdentityProviderDetails) {
            this.updateIdentityProviderDetails = updateIdentityProviderDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateIdentityProviderRequest buildWithoutInvocationCallback() {
            return new UpdateIdentityProviderRequest(this.identityProviderId, this.updateIdentityProviderDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateIdentityProviderRequest.Builder(identityProviderId=" + this.identityProviderId + ", updateIdentityProviderDetails=" + this.updateIdentityProviderDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

