/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.UpdateSmtpCredentialDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateSmtpCredentialRequest
extends BmcRequest {
    private String userId;
    private String smtpCredentialId;
    private UpdateSmtpCredentialDetails updateSmtpCredentialDetails;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "smtpCredentialId", "updateSmtpCredentialDetails", "ifMatch"})
    UpdateSmtpCredentialRequest(String userId, String smtpCredentialId, UpdateSmtpCredentialDetails updateSmtpCredentialDetails, String ifMatch) {
        this.userId = userId;
        this.smtpCredentialId = smtpCredentialId;
        this.updateSmtpCredentialDetails = updateSmtpCredentialDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSmtpCredentialId() {
        return this.smtpCredentialId;
    }

    public UpdateSmtpCredentialDetails getUpdateSmtpCredentialDetails() {
        return this.updateSmtpCredentialDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userId;
        private String smtpCredentialId;
        private UpdateSmtpCredentialDetails updateSmtpCredentialDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSmtpCredentialRequest o) {
            this.userId(o.getUserId());
            this.smtpCredentialId(o.getSmtpCredentialId());
            this.updateSmtpCredentialDetails(o.getUpdateSmtpCredentialDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSmtpCredentialRequest build() {
            UpdateSmtpCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder smtpCredentialId(String smtpCredentialId) {
            this.smtpCredentialId = smtpCredentialId;
            return this;
        }

        public Builder updateSmtpCredentialDetails(UpdateSmtpCredentialDetails updateSmtpCredentialDetails) {
            this.updateSmtpCredentialDetails = updateSmtpCredentialDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateSmtpCredentialRequest buildWithoutInvocationCallback() {
            return new UpdateSmtpCredentialRequest(this.userId, this.smtpCredentialId, this.updateSmtpCredentialDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateSmtpCredentialRequest.Builder(userId=" + this.userId + ", smtpCredentialId=" + this.smtpCredentialId + ", updateSmtpCredentialDetails=" + this.updateSmtpCredentialDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

