/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.UpdateTagDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateTagRequest
extends BmcRequest {
    private String tagNamespaceId;
    private String tagName;
    private UpdateTagDetails updateTagDetails;
    private String ifMatch;

    @ConstructorProperties(value={"tagNamespaceId", "tagName", "updateTagDetails", "ifMatch"})
    UpdateTagRequest(String tagNamespaceId, String tagName, UpdateTagDetails updateTagDetails, String ifMatch) {
        this.tagNamespaceId = tagNamespaceId;
        this.tagName = tagName;
        this.updateTagDetails = updateTagDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTagNamespaceId() {
        return this.tagNamespaceId;
    }

    public String getTagName() {
        return this.tagName;
    }

    public UpdateTagDetails getUpdateTagDetails() {
        return this.updateTagDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String tagNamespaceId;
        private String tagName;
        private UpdateTagDetails updateTagDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTagRequest o) {
            this.tagNamespaceId(o.getTagNamespaceId());
            this.tagName(o.getTagName());
            this.updateTagDetails(o.getUpdateTagDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTagRequest build() {
            UpdateTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tagNamespaceId(String tagNamespaceId) {
            this.tagNamespaceId = tagNamespaceId;
            return this;
        }

        public Builder tagName(String tagName) {
            this.tagName = tagName;
            return this;
        }

        public Builder updateTagDetails(UpdateTagDetails updateTagDetails) {
            this.updateTagDetails = updateTagDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateTagRequest buildWithoutInvocationCallback() {
            return new UpdateTagRequest(this.tagNamespaceId, this.tagName, this.updateTagDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateTagRequest.Builder(tagNamespaceId=" + this.tagNamespaceId + ", tagName=" + this.tagName + ", updateTagDetails=" + this.updateTagDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

