/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.UpdateUserCapabilitiesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateUserCapabilitiesRequest
extends BmcRequest {
    private String userId;
    private UpdateUserCapabilitiesDetails updateUserCapabilitiesDetails;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "updateUserCapabilitiesDetails", "ifMatch"})
    UpdateUserCapabilitiesRequest(String userId, UpdateUserCapabilitiesDetails updateUserCapabilitiesDetails, String ifMatch) {
        this.userId = userId;
        this.updateUserCapabilitiesDetails = updateUserCapabilitiesDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public UpdateUserCapabilitiesDetails getUpdateUserCapabilitiesDetails() {
        return this.updateUserCapabilitiesDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String userId;
        private UpdateUserCapabilitiesDetails updateUserCapabilitiesDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateUserCapabilitiesRequest o) {
            this.userId(o.getUserId());
            this.updateUserCapabilitiesDetails(o.getUpdateUserCapabilitiesDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateUserCapabilitiesRequest build() {
            UpdateUserCapabilitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder updateUserCapabilitiesDetails(UpdateUserCapabilitiesDetails updateUserCapabilitiesDetails) {
            this.updateUserCapabilitiesDetails = updateUserCapabilitiesDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateUserCapabilitiesRequest buildWithoutInvocationCallback() {
            return new UpdateUserCapabilitiesRequest(this.userId, this.updateUserCapabilitiesDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateUserCapabilitiesRequest.Builder(userId=" + this.userId + ", updateUserCapabilitiesDetails=" + this.updateUserCapabilitiesDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

