/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.TagDefaultSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class AssembleEffectiveTagSetResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<TagDefaultSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    AssembleEffectiveTagSetResponse(String opcRequestId, String opcNextPage, List<TagDefaultSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<TagDefaultSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<TagDefaultSummary> items;

        public Builder copy(AssembleEffectiveTagSetResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<TagDefaultSummary> items) {
            this.items = items;
            return this;
        }

        public AssembleEffectiveTagSetResponse build() {
            return new AssembleEffectiveTagSetResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "AssembleEffectiveTagSetResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

