/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.UIPassword;
import java.beans.ConstructorProperties;

public class CreateOrResetUIPasswordResponse {
    private String opcRequestId;
    private String etag;
    private UIPassword uIPassword;

    @ConstructorProperties(value={"opcRequestId", "etag", "uIPassword"})
    CreateOrResetUIPasswordResponse(String opcRequestId, String etag, UIPassword uIPassword) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.uIPassword = uIPassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public UIPassword getUIPassword() {
        return this.uIPassword;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private UIPassword uIPassword;

        public Builder copy(CreateOrResetUIPasswordResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.uIPassword(o.getUIPassword());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder uIPassword(UIPassword uIPassword) {
            this.uIPassword = uIPassword;
            return this;
        }

        public CreateOrResetUIPasswordResponse build() {
            return new CreateOrResetUIPasswordResponse(this.opcRequestId, this.etag, this.uIPassword);
        }

        public String toString() {
            return "CreateOrResetUIPasswordResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", uIPassword=" + this.uIPassword + ")";
        }
    }
}

