/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.Policy;
import java.beans.ConstructorProperties;

public class GetPolicyResponse {
    private String opcRequestId;
    private String etag;
    private Policy policy;

    @ConstructorProperties(value={"opcRequestId", "etag", "policy"})
    GetPolicyResponse(String opcRequestId, String etag, Policy policy) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.policy = policy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Policy policy;

        public Builder copy(GetPolicyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.policy(o.getPolicy());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder policy(Policy policy) {
            this.policy = policy;
            return this;
        }

        public GetPolicyResponse build() {
            return new GetPolicyResponse(this.opcRequestId, this.etag, this.policy);
        }

        public String toString() {
            return "GetPolicyResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", policy=" + this.policy + ")";
        }
    }
}

