/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.UIPasswordInformation;
import java.beans.ConstructorProperties;

public class GetUserUIPasswordInformationResponse {
    private String opcRequestId;
    private UIPasswordInformation uIPasswordInformation;

    @ConstructorProperties(value={"opcRequestId", "uIPasswordInformation"})
    GetUserUIPasswordInformationResponse(String opcRequestId, UIPasswordInformation uIPasswordInformation) {
        this.opcRequestId = opcRequestId;
        this.uIPasswordInformation = uIPasswordInformation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public UIPasswordInformation getUIPasswordInformation() {
        return this.uIPasswordInformation;
    }

    public static class Builder {
        private String opcRequestId;
        private UIPasswordInformation uIPasswordInformation;

        public Builder copy(GetUserUIPasswordInformationResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.uIPasswordInformation(o.getUIPasswordInformation());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder uIPasswordInformation(UIPasswordInformation uIPasswordInformation) {
            this.uIPasswordInformation = uIPasswordInformation;
            return this;
        }

        public GetUserUIPasswordInformationResponse build() {
            return new GetUserUIPasswordInformationResponse(this.opcRequestId, this.uIPasswordInformation);
        }

        public String toString() {
            return "GetUserUIPasswordInformationResponse.Builder(opcRequestId=" + this.opcRequestId + ", uIPasswordInformation=" + this.uIPasswordInformation + ")";
        }
    }
}

