/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.Tag;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListCostTrackingTagsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<Tag> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListCostTrackingTagsResponse(String opcRequestId, String opcNextPage, List<Tag> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<Tag> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<Tag> items;

        public Builder copy(ListCostTrackingTagsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<Tag> items) {
            this.items = items;
            return this;
        }

        public ListCostTrackingTagsResponse build() {
            return new ListCostTrackingTagsResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListCostTrackingTagsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

