/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.ScimClientCredentials;
import java.beans.ConstructorProperties;

public class ResetIdpScimClientResponse {
    private String opcRequestId;
    private ScimClientCredentials scimClientCredentials;

    @ConstructorProperties(value={"opcRequestId", "scimClientCredentials"})
    ResetIdpScimClientResponse(String opcRequestId, ScimClientCredentials scimClientCredentials) {
        this.opcRequestId = opcRequestId;
        this.scimClientCredentials = scimClientCredentials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ScimClientCredentials getScimClientCredentials() {
        return this.scimClientCredentials;
    }

    public static class Builder {
        private String opcRequestId;
        private ScimClientCredentials scimClientCredentials;

        public Builder copy(ResetIdpScimClientResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.scimClientCredentials(o.getScimClientCredentials());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scimClientCredentials(ScimClientCredentials scimClientCredentials) {
            this.scimClientCredentials = scimClientCredentials;
            return this;
        }

        public ResetIdpScimClientResponse build() {
            return new ResetIdpScimClientResponse(this.opcRequestId, this.scimClientCredentials);
        }

        public String toString() {
            return "ResetIdpScimClientResponse.Builder(opcRequestId=" + this.opcRequestId + ", scimClientCredentials=" + this.scimClientCredentials + ")";
        }
    }
}

