/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.User;
import java.beans.ConstructorProperties;

public class UpdateUserCapabilitiesResponse {
    private String opcRequestId;
    private String etag;
    private User user;

    @ConstructorProperties(value={"opcRequestId", "etag", "user"})
    UpdateUserCapabilitiesResponse(String opcRequestId, String etag, User user) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.user = user;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public User getUser() {
        return this.user;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private User user;

        public Builder copy(UpdateUserCapabilitiesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.user(o.getUser());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public UpdateUserCapabilitiesResponse build() {
            return new UpdateUserCapabilitiesResponse(this.opcRequestId, this.etag, this.user);
        }

        public String toString() {
            return "UpdateUserCapabilitiesResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", user=" + this.user + ")";
        }
    }
}

