/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.keymanagement.KmsCryptoAsync;
import com.oracle.bmc.keymanagement.KmsCryptoAsyncClientBuilder;
import com.oracle.bmc.keymanagement.internal.http.DecryptConverter;
import com.oracle.bmc.keymanagement.internal.http.EncryptConverter;
import com.oracle.bmc.keymanagement.internal.http.GenerateDataEncryptionKeyConverter;
import com.oracle.bmc.keymanagement.requests.DecryptRequest;
import com.oracle.bmc.keymanagement.requests.EncryptRequest;
import com.oracle.bmc.keymanagement.requests.GenerateDataEncryptionKeyRequest;
import com.oracle.bmc.keymanagement.responses.DecryptResponse;
import com.oracle.bmc.keymanagement.responses.EncryptResponse;
import com.oracle.bmc.keymanagement.responses.GenerateDataEncryptionKeyResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsCryptoAsyncClient
implements KmsCryptoAsync {
    private static final Logger LOG = LoggerFactory.getLogger(KmsCryptoAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSCRYPTO").serviceEndpointPrefix("kms").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public KmsCryptoAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public KmsCryptoAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public KmsCryptoAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public KmsCryptoAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public KmsCryptoAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public KmsCryptoAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public KmsCryptoAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static KmsCryptoAsyncClientBuilder builder() {
        return new KmsCryptoAsyncClientBuilder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<DecryptResponse> decrypt(DecryptRequest request, AsyncHandler<DecryptRequest, DecryptResponse> handler) {
        LOG.trace("Called async decrypt");
        final DecryptRequest interceptedRequest = DecryptConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DecryptConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DecryptResponse> transformer = DecryptConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DecryptRequest, DecryptResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DecryptRequest, DecryptResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DecryptRequest, DecryptResponse> onSuccess = new SuccessConsumer<DecryptRequest, DecryptResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DecryptRequest> onError = new ErrorConsumer<DecryptRequest>(this, interceptedRequest);
                    KmsCryptoAsyncClient.this.client.post(ib, interceptedRequest.getDecryptDataDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DecryptRequest, DecryptResponse> onSuccess = handler == null ? null : new SuccessConsumer<DecryptRequest, DecryptResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DecryptRequest> onError = handler == null ? null : new ErrorConsumer<DecryptRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getDecryptDataDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DecryptResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsCryptoAsyncClient.this.client.post(ib, interceptedRequest.getDecryptDataDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DecryptResponse>(responseFuture, transformer);
    }

    @Override
    public Future<EncryptResponse> encrypt(EncryptRequest request, AsyncHandler<EncryptRequest, EncryptResponse> handler) {
        LOG.trace("Called async encrypt");
        final EncryptRequest interceptedRequest = EncryptConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = EncryptConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, EncryptResponse> transformer = EncryptConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<EncryptRequest, EncryptResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<EncryptRequest, EncryptResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<EncryptRequest, EncryptResponse> onSuccess = new SuccessConsumer<EncryptRequest, EncryptResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<EncryptRequest> onError = new ErrorConsumer<EncryptRequest>(this, interceptedRequest);
                    KmsCryptoAsyncClient.this.client.post(ib, interceptedRequest.getEncryptDataDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<EncryptRequest, EncryptResponse> onSuccess = handler == null ? null : new SuccessConsumer<EncryptRequest, EncryptResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<EncryptRequest> onError = handler == null ? null : new ErrorConsumer<EncryptRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getEncryptDataDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, EncryptResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsCryptoAsyncClient.this.client.post(ib, interceptedRequest.getEncryptDataDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, EncryptResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GenerateDataEncryptionKeyResponse> generateDataEncryptionKey(GenerateDataEncryptionKeyRequest request, AsyncHandler<GenerateDataEncryptionKeyRequest, GenerateDataEncryptionKeyResponse> handler) {
        LOG.trace("Called async generateDataEncryptionKey");
        final GenerateDataEncryptionKeyRequest interceptedRequest = GenerateDataEncryptionKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GenerateDataEncryptionKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GenerateDataEncryptionKeyResponse> transformer = GenerateDataEncryptionKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GenerateDataEncryptionKeyRequest, GenerateDataEncryptionKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GenerateDataEncryptionKeyRequest, GenerateDataEncryptionKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GenerateDataEncryptionKeyRequest, GenerateDataEncryptionKeyResponse> onSuccess = new SuccessConsumer<GenerateDataEncryptionKeyRequest, GenerateDataEncryptionKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GenerateDataEncryptionKeyRequest> onError = new ErrorConsumer<GenerateDataEncryptionKeyRequest>(this, interceptedRequest);
                    KmsCryptoAsyncClient.this.client.post(ib, interceptedRequest.getGenerateKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GenerateDataEncryptionKeyRequest, GenerateDataEncryptionKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GenerateDataEncryptionKeyRequest, GenerateDataEncryptionKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GenerateDataEncryptionKeyRequest> onError = handler == null ? null : new ErrorConsumer<GenerateDataEncryptionKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getGenerateKeyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GenerateDataEncryptionKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsCryptoAsyncClient.this.client.post(ib, interceptedRequest.getGenerateKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GenerateDataEncryptionKeyResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }
}

