/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.keymanagement.KmsManagementAsync;
import com.oracle.bmc.keymanagement.KmsManagementAsyncClientBuilder;
import com.oracle.bmc.keymanagement.internal.http.CancelKeyDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.ChangeKeyCompartmentConverter;
import com.oracle.bmc.keymanagement.internal.http.CreateKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.CreateKeyVersionConverter;
import com.oracle.bmc.keymanagement.internal.http.DisableKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.EnableKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.GetKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.GetKeyVersionConverter;
import com.oracle.bmc.keymanagement.internal.http.ListKeyVersionsConverter;
import com.oracle.bmc.keymanagement.internal.http.ListKeysConverter;
import com.oracle.bmc.keymanagement.internal.http.ScheduleKeyDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.UpdateKeyConverter;
import com.oracle.bmc.keymanagement.requests.CancelKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeKeyCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.DisableKeyRequest;
import com.oracle.bmc.keymanagement.requests.EnableKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.ListKeyVersionsRequest;
import com.oracle.bmc.keymanagement.requests.ListKeysRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateKeyRequest;
import com.oracle.bmc.keymanagement.responses.CancelKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeKeyCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.DisableKeyResponse;
import com.oracle.bmc.keymanagement.responses.EnableKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.ListKeyVersionsResponse;
import com.oracle.bmc.keymanagement.responses.ListKeysResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateKeyResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsManagementAsyncClient
implements KmsManagementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(KmsManagementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSMANAGEMENT").serviceEndpointPrefix("kms").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public KmsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public KmsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public KmsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public KmsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public KmsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public KmsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public KmsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static KmsManagementAsyncClientBuilder builder() {
        return new KmsManagementAsyncClientBuilder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CancelKeyDeletionResponse> cancelKeyDeletion(CancelKeyDeletionRequest request, AsyncHandler<CancelKeyDeletionRequest, CancelKeyDeletionResponse> handler) {
        LOG.trace("Called async cancelKeyDeletion");
        final CancelKeyDeletionRequest interceptedRequest = CancelKeyDeletionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CancelKeyDeletionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CancelKeyDeletionResponse> transformer = CancelKeyDeletionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CancelKeyDeletionRequest, CancelKeyDeletionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CancelKeyDeletionRequest, CancelKeyDeletionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CancelKeyDeletionRequest, CancelKeyDeletionResponse> onSuccess = new SuccessConsumer<CancelKeyDeletionRequest, CancelKeyDeletionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CancelKeyDeletionRequest> onError = new ErrorConsumer<CancelKeyDeletionRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CancelKeyDeletionRequest, CancelKeyDeletionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CancelKeyDeletionRequest, CancelKeyDeletionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CancelKeyDeletionRequest> onError = handler == null ? null : new ErrorConsumer<CancelKeyDeletionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CancelKeyDeletionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CancelKeyDeletionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeKeyCompartmentResponse> changeKeyCompartment(ChangeKeyCompartmentRequest request, AsyncHandler<ChangeKeyCompartmentRequest, ChangeKeyCompartmentResponse> handler) {
        LOG.trace("Called async changeKeyCompartment");
        final ChangeKeyCompartmentRequest interceptedRequest = ChangeKeyCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeKeyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeKeyCompartmentResponse> transformer = ChangeKeyCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeKeyCompartmentRequest, ChangeKeyCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeKeyCompartmentRequest, ChangeKeyCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeKeyCompartmentRequest, ChangeKeyCompartmentResponse> onSuccess = new SuccessConsumer<ChangeKeyCompartmentRequest, ChangeKeyCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeKeyCompartmentRequest> onError = new ErrorConsumer<ChangeKeyCompartmentRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.post(ib, interceptedRequest.getChangeKeyCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeKeyCompartmentRequest, ChangeKeyCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeKeyCompartmentRequest, ChangeKeyCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeKeyCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeKeyCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeKeyCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeKeyCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.post(ib, interceptedRequest.getChangeKeyCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeKeyCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateKeyResponse> createKey(CreateKeyRequest request, AsyncHandler<CreateKeyRequest, CreateKeyResponse> handler) {
        LOG.trace("Called async createKey");
        final CreateKeyRequest interceptedRequest = CreateKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateKeyResponse> transformer = CreateKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateKeyRequest, CreateKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateKeyRequest, CreateKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateKeyRequest, CreateKeyResponse> onSuccess = new SuccessConsumer<CreateKeyRequest, CreateKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateKeyRequest> onError = new ErrorConsumer<CreateKeyRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateKeyRequest, CreateKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateKeyRequest, CreateKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateKeyRequest> onError = handler == null ? null : new ErrorConsumer<CreateKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateKeyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateKeyVersionResponse> createKeyVersion(CreateKeyVersionRequest request, AsyncHandler<CreateKeyVersionRequest, CreateKeyVersionResponse> handler) {
        LOG.trace("Called async createKeyVersion");
        final CreateKeyVersionRequest interceptedRequest = CreateKeyVersionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateKeyVersionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateKeyVersionResponse> transformer = CreateKeyVersionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateKeyVersionRequest, CreateKeyVersionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateKeyVersionRequest, CreateKeyVersionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateKeyVersionRequest, CreateKeyVersionResponse> onSuccess = new SuccessConsumer<CreateKeyVersionRequest, CreateKeyVersionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateKeyVersionRequest> onError = new ErrorConsumer<CreateKeyVersionRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateKeyVersionRequest, CreateKeyVersionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateKeyVersionRequest, CreateKeyVersionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateKeyVersionRequest> onError = handler == null ? null : new ErrorConsumer<CreateKeyVersionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateKeyVersionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateKeyVersionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DisableKeyResponse> disableKey(DisableKeyRequest request, AsyncHandler<DisableKeyRequest, DisableKeyResponse> handler) {
        LOG.trace("Called async disableKey");
        final DisableKeyRequest interceptedRequest = DisableKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DisableKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DisableKeyResponse> transformer = DisableKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DisableKeyRequest, DisableKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DisableKeyRequest, DisableKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DisableKeyRequest, DisableKeyResponse> onSuccess = new SuccessConsumer<DisableKeyRequest, DisableKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DisableKeyRequest> onError = new ErrorConsumer<DisableKeyRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DisableKeyRequest, DisableKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DisableKeyRequest, DisableKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DisableKeyRequest> onError = handler == null ? null : new ErrorConsumer<DisableKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DisableKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DisableKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<EnableKeyResponse> enableKey(EnableKeyRequest request, AsyncHandler<EnableKeyRequest, EnableKeyResponse> handler) {
        LOG.trace("Called async enableKey");
        final EnableKeyRequest interceptedRequest = EnableKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = EnableKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, EnableKeyResponse> transformer = EnableKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<EnableKeyRequest, EnableKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<EnableKeyRequest, EnableKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<EnableKeyRequest, EnableKeyResponse> onSuccess = new SuccessConsumer<EnableKeyRequest, EnableKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<EnableKeyRequest> onError = new ErrorConsumer<EnableKeyRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<EnableKeyRequest, EnableKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<EnableKeyRequest, EnableKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<EnableKeyRequest> onError = handler == null ? null : new ErrorConsumer<EnableKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, EnableKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, EnableKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetKeyResponse> getKey(GetKeyRequest request, AsyncHandler<GetKeyRequest, GetKeyResponse> handler) {
        LOG.trace("Called async getKey");
        final GetKeyRequest interceptedRequest = GetKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetKeyResponse> transformer = GetKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetKeyRequest, GetKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetKeyRequest, GetKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetKeyRequest, GetKeyResponse> onSuccess = new SuccessConsumer<GetKeyRequest, GetKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetKeyRequest> onError = new ErrorConsumer<GetKeyRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetKeyRequest, GetKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetKeyRequest, GetKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetKeyRequest> onError = handler == null ? null : new ErrorConsumer<GetKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetKeyVersionResponse> getKeyVersion(GetKeyVersionRequest request, AsyncHandler<GetKeyVersionRequest, GetKeyVersionResponse> handler) {
        LOG.trace("Called async getKeyVersion");
        final GetKeyVersionRequest interceptedRequest = GetKeyVersionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetKeyVersionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetKeyVersionResponse> transformer = GetKeyVersionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetKeyVersionRequest, GetKeyVersionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetKeyVersionRequest, GetKeyVersionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetKeyVersionRequest, GetKeyVersionResponse> onSuccess = new SuccessConsumer<GetKeyVersionRequest, GetKeyVersionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetKeyVersionRequest> onError = new ErrorConsumer<GetKeyVersionRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetKeyVersionRequest, GetKeyVersionResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetKeyVersionRequest, GetKeyVersionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetKeyVersionRequest> onError = handler == null ? null : new ErrorConsumer<GetKeyVersionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetKeyVersionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetKeyVersionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListKeyVersionsResponse> listKeyVersions(ListKeyVersionsRequest request, AsyncHandler<ListKeyVersionsRequest, ListKeyVersionsResponse> handler) {
        LOG.trace("Called async listKeyVersions");
        final ListKeyVersionsRequest interceptedRequest = ListKeyVersionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListKeyVersionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListKeyVersionsResponse> transformer = ListKeyVersionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListKeyVersionsRequest, ListKeyVersionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListKeyVersionsRequest, ListKeyVersionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListKeyVersionsRequest, ListKeyVersionsResponse> onSuccess = new SuccessConsumer<ListKeyVersionsRequest, ListKeyVersionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListKeyVersionsRequest> onError = new ErrorConsumer<ListKeyVersionsRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListKeyVersionsRequest, ListKeyVersionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListKeyVersionsRequest, ListKeyVersionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListKeyVersionsRequest> onError = handler == null ? null : new ErrorConsumer<ListKeyVersionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListKeyVersionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListKeyVersionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListKeysResponse> listKeys(ListKeysRequest request, AsyncHandler<ListKeysRequest, ListKeysResponse> handler) {
        LOG.trace("Called async listKeys");
        final ListKeysRequest interceptedRequest = ListKeysConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListKeysConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListKeysResponse> transformer = ListKeysConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListKeysRequest, ListKeysResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListKeysRequest, ListKeysResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListKeysRequest, ListKeysResponse> onSuccess = new SuccessConsumer<ListKeysRequest, ListKeysResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListKeysRequest> onError = new ErrorConsumer<ListKeysRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListKeysRequest, ListKeysResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListKeysRequest, ListKeysResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListKeysRequest> onError = handler == null ? null : new ErrorConsumer<ListKeysRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListKeysResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListKeysResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ScheduleKeyDeletionResponse> scheduleKeyDeletion(ScheduleKeyDeletionRequest request, AsyncHandler<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResponse> handler) {
        LOG.trace("Called async scheduleKeyDeletion");
        final ScheduleKeyDeletionRequest interceptedRequest = ScheduleKeyDeletionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ScheduleKeyDeletionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ScheduleKeyDeletionResponse> transformer = ScheduleKeyDeletionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResponse> onSuccess = new SuccessConsumer<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ScheduleKeyDeletionRequest> onError = new ErrorConsumer<ScheduleKeyDeletionRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.post(ib, interceptedRequest.getScheduleKeyDeletionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResponse> onSuccess = handler == null ? null : new SuccessConsumer<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ScheduleKeyDeletionRequest> onError = handler == null ? null : new ErrorConsumer<ScheduleKeyDeletionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getScheduleKeyDeletionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ScheduleKeyDeletionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.post(ib, interceptedRequest.getScheduleKeyDeletionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ScheduleKeyDeletionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateKeyResponse> updateKey(UpdateKeyRequest request, AsyncHandler<UpdateKeyRequest, UpdateKeyResponse> handler) {
        LOG.trace("Called async updateKey");
        final UpdateKeyRequest interceptedRequest = UpdateKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateKeyResponse> transformer = UpdateKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateKeyRequest, UpdateKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateKeyRequest, UpdateKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateKeyRequest, UpdateKeyResponse> onSuccess = new SuccessConsumer<UpdateKeyRequest, UpdateKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateKeyRequest> onError = new ErrorConsumer<UpdateKeyRequest>(this, interceptedRequest);
                    KmsManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateKeyRequest, UpdateKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateKeyRequest, UpdateKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateKeyRequest> onError = handler == null ? null : new ErrorConsumer<UpdateKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateKeyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateKeyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateKeyResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }
}

