/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.keymanagement.KmsVaultAsync;
import com.oracle.bmc.keymanagement.internal.http.CancelVaultDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.ChangeVaultCompartmentConverter;
import com.oracle.bmc.keymanagement.internal.http.CreateVaultConverter;
import com.oracle.bmc.keymanagement.internal.http.GetVaultConverter;
import com.oracle.bmc.keymanagement.internal.http.ListVaultsConverter;
import com.oracle.bmc.keymanagement.internal.http.ScheduleVaultDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.UpdateVaultConverter;
import com.oracle.bmc.keymanagement.requests.CancelVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeVaultCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateVaultRequest;
import com.oracle.bmc.keymanagement.responses.CancelVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeVaultCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultsResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateVaultResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsVaultAsyncClient
implements KmsVaultAsync {
    private static final Logger LOG = LoggerFactory.getLogger(KmsVaultAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSVAULT").serviceEndpointPrefix("kms").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public KmsVaultAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public KmsVaultAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public KmsVaultAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CancelVaultDeletionResponse> cancelVaultDeletion(CancelVaultDeletionRequest request, AsyncHandler<CancelVaultDeletionRequest, CancelVaultDeletionResponse> handler) {
        LOG.trace("Called async cancelVaultDeletion");
        final CancelVaultDeletionRequest interceptedRequest = CancelVaultDeletionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CancelVaultDeletionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CancelVaultDeletionResponse> transformer = CancelVaultDeletionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CancelVaultDeletionRequest, CancelVaultDeletionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CancelVaultDeletionRequest, CancelVaultDeletionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CancelVaultDeletionRequest, CancelVaultDeletionResponse> onSuccess = new SuccessConsumer<CancelVaultDeletionRequest, CancelVaultDeletionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CancelVaultDeletionRequest> onError = new ErrorConsumer<CancelVaultDeletionRequest>(this, interceptedRequest);
                    KmsVaultAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CancelVaultDeletionRequest, CancelVaultDeletionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CancelVaultDeletionRequest, CancelVaultDeletionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CancelVaultDeletionRequest> onError = handler == null ? null : new ErrorConsumer<CancelVaultDeletionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CancelVaultDeletionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsVaultAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CancelVaultDeletionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeVaultCompartmentResponse> changeVaultCompartment(ChangeVaultCompartmentRequest request, AsyncHandler<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse> handler) {
        LOG.trace("Called async changeVaultCompartment");
        final ChangeVaultCompartmentRequest interceptedRequest = ChangeVaultCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeVaultCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeVaultCompartmentResponse> transformer = ChangeVaultCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse> onSuccess = new SuccessConsumer<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeVaultCompartmentRequest> onError = new ErrorConsumer<ChangeVaultCompartmentRequest>(this, interceptedRequest);
                    KmsVaultAsyncClient.this.client.post(ib, interceptedRequest.getChangeVaultCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeVaultCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeVaultCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeVaultCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeVaultCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsVaultAsyncClient.this.client.post(ib, interceptedRequest.getChangeVaultCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeVaultCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVaultResponse> createVault(CreateVaultRequest request, AsyncHandler<CreateVaultRequest, CreateVaultResponse> handler) {
        LOG.trace("Called async createVault");
        final CreateVaultRequest interceptedRequest = CreateVaultConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVaultConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVaultResponse> transformer = CreateVaultConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVaultRequest, CreateVaultResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVaultRequest, CreateVaultResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVaultRequest, CreateVaultResponse> onSuccess = new SuccessConsumer<CreateVaultRequest, CreateVaultResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVaultRequest> onError = new ErrorConsumer<CreateVaultRequest>(this, interceptedRequest);
                    KmsVaultAsyncClient.this.client.post(ib, interceptedRequest.getCreateVaultDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVaultRequest, CreateVaultResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVaultRequest, CreateVaultResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVaultRequest> onError = handler == null ? null : new ErrorConsumer<CreateVaultRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateVaultDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVaultResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsVaultAsyncClient.this.client.post(ib, interceptedRequest.getCreateVaultDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVaultResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVaultResponse> getVault(GetVaultRequest request, AsyncHandler<GetVaultRequest, GetVaultResponse> handler) {
        LOG.trace("Called async getVault");
        final GetVaultRequest interceptedRequest = GetVaultConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVaultConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVaultResponse> transformer = GetVaultConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVaultRequest, GetVaultResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVaultRequest, GetVaultResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVaultRequest, GetVaultResponse> onSuccess = new SuccessConsumer<GetVaultRequest, GetVaultResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVaultRequest> onError = new ErrorConsumer<GetVaultRequest>(this, interceptedRequest);
                    KmsVaultAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVaultRequest, GetVaultResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVaultRequest, GetVaultResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVaultRequest> onError = handler == null ? null : new ErrorConsumer<GetVaultRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVaultResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsVaultAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVaultResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVaultsResponse> listVaults(ListVaultsRequest request, AsyncHandler<ListVaultsRequest, ListVaultsResponse> handler) {
        LOG.trace("Called async listVaults");
        final ListVaultsRequest interceptedRequest = ListVaultsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVaultsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVaultsResponse> transformer = ListVaultsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVaultsRequest, ListVaultsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVaultsRequest, ListVaultsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVaultsRequest, ListVaultsResponse> onSuccess = new SuccessConsumer<ListVaultsRequest, ListVaultsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVaultsRequest> onError = new ErrorConsumer<ListVaultsRequest>(this, interceptedRequest);
                    KmsVaultAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVaultsRequest, ListVaultsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVaultsRequest, ListVaultsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVaultsRequest> onError = handler == null ? null : new ErrorConsumer<ListVaultsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVaultsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsVaultAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVaultsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ScheduleVaultDeletionResponse> scheduleVaultDeletion(ScheduleVaultDeletionRequest request, AsyncHandler<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse> handler) {
        LOG.trace("Called async scheduleVaultDeletion");
        final ScheduleVaultDeletionRequest interceptedRequest = ScheduleVaultDeletionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ScheduleVaultDeletionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ScheduleVaultDeletionResponse> transformer = ScheduleVaultDeletionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse> onSuccess = new SuccessConsumer<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ScheduleVaultDeletionRequest> onError = new ErrorConsumer<ScheduleVaultDeletionRequest>(this, interceptedRequest);
                    KmsVaultAsyncClient.this.client.post(ib, interceptedRequest.getScheduleVaultDeletionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse> onSuccess = handler == null ? null : new SuccessConsumer<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ScheduleVaultDeletionRequest> onError = handler == null ? null : new ErrorConsumer<ScheduleVaultDeletionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getScheduleVaultDeletionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ScheduleVaultDeletionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsVaultAsyncClient.this.client.post(ib, interceptedRequest.getScheduleVaultDeletionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ScheduleVaultDeletionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVaultResponse> updateVault(UpdateVaultRequest request, AsyncHandler<UpdateVaultRequest, UpdateVaultResponse> handler) {
        LOG.trace("Called async updateVault");
        final UpdateVaultRequest interceptedRequest = UpdateVaultConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVaultConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVaultResponse> transformer = UpdateVaultConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVaultRequest, UpdateVaultResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVaultRequest, UpdateVaultResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVaultRequest, UpdateVaultResponse> onSuccess = new SuccessConsumer<UpdateVaultRequest, UpdateVaultResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVaultRequest> onError = new ErrorConsumer<UpdateVaultRequest>(this, interceptedRequest);
                    KmsVaultAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVaultDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVaultRequest, UpdateVaultResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVaultRequest, UpdateVaultResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVaultRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVaultRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVaultDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVaultResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return KmsVaultAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVaultDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVaultResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, KmsVaultAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public KmsVaultAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new KmsVaultAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

