/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.keymanagement.KmsVault;
import com.oracle.bmc.keymanagement.KmsVaultPaginators;
import com.oracle.bmc.keymanagement.KmsVaultWaiters;
import com.oracle.bmc.keymanagement.internal.http.CancelVaultDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.ChangeVaultCompartmentConverter;
import com.oracle.bmc.keymanagement.internal.http.CreateVaultConverter;
import com.oracle.bmc.keymanagement.internal.http.GetVaultConverter;
import com.oracle.bmc.keymanagement.internal.http.ListVaultsConverter;
import com.oracle.bmc.keymanagement.internal.http.ScheduleVaultDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.UpdateVaultConverter;
import com.oracle.bmc.keymanagement.requests.CancelVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeVaultCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateVaultRequest;
import com.oracle.bmc.keymanagement.responses.CancelVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeVaultCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultsResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateVaultResponse;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsVaultClient
implements KmsVault {
    private static final Logger LOG = LoggerFactory.getLogger(KmsVaultClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSVAULT").serviceEndpointPrefix("kms").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final KmsVaultWaiters waiters;
    private final KmsVaultPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public KmsVaultClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public KmsVaultClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public KmsVaultClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public KmsVaultClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public KmsVaultClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public KmsVaultClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public KmsVaultClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public KmsVaultClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("KmsVault-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new KmsVaultWaiters(executorService, this);
        this.paginators = new KmsVaultPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CancelVaultDeletionResponse cancelVaultDeletion(CancelVaultDeletionRequest request) {
        LOG.trace("Called cancelVaultDeletion");
        CancelVaultDeletionRequest interceptedRequest = CancelVaultDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelVaultDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelVaultDeletionResponse> transformer = CancelVaultDeletionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (CancelVaultDeletionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeVaultCompartmentResponse changeVaultCompartment(ChangeVaultCompartmentRequest request) {
        LOG.trace("Called changeVaultCompartment");
        ChangeVaultCompartmentRequest interceptedRequest = ChangeVaultCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeVaultCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeVaultCompartmentResponse> transformer = ChangeVaultCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeVaultCompartmentDetails(), retriedRequest);
                return (ChangeVaultCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVaultResponse createVault(CreateVaultRequest request) {
        LOG.trace("Called createVault");
        CreateVaultRequest interceptedRequest = CreateVaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVaultResponse> transformer = CreateVaultConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateVaultDetails(), retriedRequest);
                return (CreateVaultResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVaultResponse getVault(GetVaultRequest request) {
        LOG.trace("Called getVault");
        GetVaultRequest interceptedRequest = GetVaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVaultResponse> transformer = GetVaultConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVaultResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVaultsResponse listVaults(ListVaultsRequest request) {
        LOG.trace("Called listVaults");
        ListVaultsRequest interceptedRequest = ListVaultsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVaultsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVaultsResponse> transformer = ListVaultsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVaultsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ScheduleVaultDeletionResponse scheduleVaultDeletion(ScheduleVaultDeletionRequest request) {
        LOG.trace("Called scheduleVaultDeletion");
        ScheduleVaultDeletionRequest interceptedRequest = ScheduleVaultDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScheduleVaultDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScheduleVaultDeletionResponse> transformer = ScheduleVaultDeletionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getScheduleVaultDeletionDetails(), retriedRequest);
                return (ScheduleVaultDeletionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVaultResponse updateVault(UpdateVaultRequest request) {
        LOG.trace("Called updateVault");
        UpdateVaultRequest interceptedRequest = UpdateVaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVaultResponse> transformer = UpdateVaultConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVaultDetails(), retriedRequest);
                return (UpdateVaultResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public KmsVaultWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public KmsVaultPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, KmsVaultClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public KmsVaultClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new KmsVaultClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

