/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.keymanagement.model.ChangeKeyCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ChangeKeyCompartmentRequest
extends BmcRequest {
    private String keyId;
    private ChangeKeyCompartmentDetails changeKeyCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"keyId", "changeKeyCompartmentDetails", "ifMatch", "opcRequestId", "opcRetryToken"})
    ChangeKeyCompartmentRequest(String keyId, ChangeKeyCompartmentDetails changeKeyCompartmentDetails, String ifMatch, String opcRequestId, String opcRetryToken) {
        this.keyId = keyId;
        this.changeKeyCompartmentDetails = changeKeyCompartmentDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyId() {
        return this.keyId;
    }

    public ChangeKeyCompartmentDetails getChangeKeyCompartmentDetails() {
        return this.changeKeyCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String keyId;
        private ChangeKeyCompartmentDetails changeKeyCompartmentDetails;
        private String ifMatch;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeKeyCompartmentRequest o) {
            this.keyId(o.getKeyId());
            this.changeKeyCompartmentDetails(o.getChangeKeyCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeKeyCompartmentRequest build() {
            ChangeKeyCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder changeKeyCompartmentDetails(ChangeKeyCompartmentDetails changeKeyCompartmentDetails) {
            this.changeKeyCompartmentDetails = changeKeyCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ChangeKeyCompartmentRequest buildWithoutInvocationCallback() {
            return new ChangeKeyCompartmentRequest(this.keyId, this.changeKeyCompartmentDetails, this.ifMatch, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ChangeKeyCompartmentRequest.Builder(keyId=" + this.keyId + ", changeKeyCompartmentDetails=" + this.changeKeyCompartmentDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

