/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.keymanagement.model.CreateKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateKeyRequest
extends BmcRequest {
    private CreateKeyDetails createKeyDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"createKeyDetails", "opcRequestId", "opcRetryToken"})
    CreateKeyRequest(CreateKeyDetails createKeyDetails, String opcRequestId, String opcRetryToken) {
        this.createKeyDetails = createKeyDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateKeyDetails getCreateKeyDetails() {
        return this.createKeyDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateKeyDetails createKeyDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateKeyRequest o) {
            this.createKeyDetails(o.getCreateKeyDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateKeyRequest build() {
            CreateKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createKeyDetails(CreateKeyDetails createKeyDetails) {
            this.createKeyDetails = createKeyDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateKeyRequest buildWithoutInvocationCallback() {
            return new CreateKeyRequest(this.createKeyDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateKeyRequest.Builder(createKeyDetails=" + this.createKeyDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

