/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.keymanagement.model.EncryptDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class EncryptRequest
extends BmcRequest {
    private EncryptDataDetails encryptDataDetails;
    private String opcRequestId;

    @ConstructorProperties(value={"encryptDataDetails", "opcRequestId"})
    EncryptRequest(EncryptDataDetails encryptDataDetails, String opcRequestId) {
        this.encryptDataDetails = encryptDataDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EncryptDataDetails getEncryptDataDetails() {
        return this.encryptDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private EncryptDataDetails encryptDataDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(EncryptRequest o) {
            this.encryptDataDetails(o.getEncryptDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public EncryptRequest build() {
            EncryptRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder encryptDataDetails(EncryptDataDetails encryptDataDetails) {
            this.encryptDataDetails = encryptDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public EncryptRequest buildWithoutInvocationCallback() {
            return new EncryptRequest(this.encryptDataDetails, this.opcRequestId);
        }

        public String toString() {
            return "EncryptRequest.Builder(encryptDataDetails=" + this.encryptDataDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

