/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.keymanagement.model.UpdateVaultDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateVaultRequest
extends BmcRequest {
    private String vaultId;
    private UpdateVaultDetails updateVaultDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"vaultId", "updateVaultDetails", "ifMatch", "opcRequestId"})
    UpdateVaultRequest(String vaultId, UpdateVaultDetails updateVaultDetails, String ifMatch, String opcRequestId) {
        this.vaultId = vaultId;
        this.updateVaultDetails = updateVaultDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public UpdateVaultDetails getUpdateVaultDetails() {
        return this.updateVaultDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String vaultId;
        private UpdateVaultDetails updateVaultDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVaultRequest o) {
            this.vaultId(o.getVaultId());
            this.updateVaultDetails(o.getUpdateVaultDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVaultRequest build() {
            UpdateVaultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            return this;
        }

        public Builder updateVaultDetails(UpdateVaultDetails updateVaultDetails) {
            this.updateVaultDetails = updateVaultDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateVaultRequest buildWithoutInvocationCallback() {
            return new UpdateVaultRequest(this.vaultId, this.updateVaultDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateVaultRequest.Builder(vaultId=" + this.vaultId + ", updateVaultDetails=" + this.updateVaultDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

