/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.DecryptedData;
import java.beans.ConstructorProperties;

public class DecryptResponse {
    private String opcRequestId;
    private DecryptedData decryptedData;

    @ConstructorProperties(value={"opcRequestId", "decryptedData"})
    DecryptResponse(String opcRequestId, DecryptedData decryptedData) {
        this.opcRequestId = opcRequestId;
        this.decryptedData = decryptedData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DecryptedData getDecryptedData() {
        return this.decryptedData;
    }

    public static class Builder {
        private String opcRequestId;
        private DecryptedData decryptedData;

        public Builder copy(DecryptResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.decryptedData(o.getDecryptedData());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder decryptedData(DecryptedData decryptedData) {
            this.decryptedData = decryptedData;
            return this;
        }

        public DecryptResponse build() {
            return new DecryptResponse(this.opcRequestId, this.decryptedData);
        }

        public String toString() {
            return "DecryptResponse.Builder(opcRequestId=" + this.opcRequestId + ", decryptedData=" + this.decryptedData + ")";
        }
    }
}

