/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.EncryptedData;
import java.beans.ConstructorProperties;

public class EncryptResponse {
    private String opcRequestId;
    private EncryptedData encryptedData;

    @ConstructorProperties(value={"opcRequestId", "encryptedData"})
    EncryptResponse(String opcRequestId, EncryptedData encryptedData) {
        this.opcRequestId = opcRequestId;
        this.encryptedData = encryptedData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public EncryptedData getEncryptedData() {
        return this.encryptedData;
    }

    public static class Builder {
        private String opcRequestId;
        private EncryptedData encryptedData;

        public Builder copy(EncryptResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.encryptedData(o.getEncryptedData());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder encryptedData(EncryptedData encryptedData) {
            this.encryptedData = encryptedData;
            return this;
        }

        public EncryptResponse build() {
            return new EncryptResponse(this.opcRequestId, this.encryptedData);
        }

        public String toString() {
            return "EncryptResponse.Builder(opcRequestId=" + this.opcRequestId + ", encryptedData=" + this.encryptedData + ")";
        }
    }
}

