/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.GeneratedKey;
import java.beans.ConstructorProperties;

public class GenerateDataEncryptionKeyResponse {
    private String opcRequestId;
    private GeneratedKey generatedKey;

    @ConstructorProperties(value={"opcRequestId", "generatedKey"})
    GenerateDataEncryptionKeyResponse(String opcRequestId, GeneratedKey generatedKey) {
        this.opcRequestId = opcRequestId;
        this.generatedKey = generatedKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public GeneratedKey getGeneratedKey() {
        return this.generatedKey;
    }

    public static class Builder {
        private String opcRequestId;
        private GeneratedKey generatedKey;

        public Builder copy(GenerateDataEncryptionKeyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.generatedKey(o.getGeneratedKey());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder generatedKey(GeneratedKey generatedKey) {
            this.generatedKey = generatedKey;
            return this;
        }

        public GenerateDataEncryptionKeyResponse build() {
            return new GenerateDataEncryptionKeyResponse(this.opcRequestId, this.generatedKey);
        }

        public String toString() {
            return "GenerateDataEncryptionKeyResponse.Builder(opcRequestId=" + this.opcRequestId + ", generatedKey=" + this.generatedKey + ")";
        }
    }
}

