/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.KeyVersion;
import java.beans.ConstructorProperties;

public class GetKeyVersionResponse {
    private String etag;
    private String opcRequestId;
    private KeyVersion keyVersion;

    @ConstructorProperties(value={"etag", "opcRequestId", "keyVersion"})
    GetKeyVersionResponse(String etag, String opcRequestId, KeyVersion keyVersion) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.keyVersion = keyVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public KeyVersion getKeyVersion() {
        return this.keyVersion;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private KeyVersion keyVersion;

        public Builder copy(GetKeyVersionResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.keyVersion(o.getKeyVersion());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder keyVersion(KeyVersion keyVersion) {
            this.keyVersion = keyVersion;
            return this;
        }

        public GetKeyVersionResponse build() {
            return new GetKeyVersionResponse(this.etag, this.opcRequestId, this.keyVersion);
        }

        public String toString() {
            return "GetKeyVersionResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", keyVersion=" + this.keyVersion + ")";
        }
    }
}

