/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.Vault;
import java.beans.ConstructorProperties;

public class GetVaultResponse {
    private String etag;
    private String opcRequestId;
    private Vault vault;

    @ConstructorProperties(value={"etag", "opcRequestId", "vault"})
    GetVaultResponse(String etag, String opcRequestId, Vault vault) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.vault = vault;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Vault getVault() {
        return this.vault;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Vault vault;

        public Builder copy(GetVaultResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.vault(o.getVault());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder vault(Vault vault) {
            this.vault = vault;
            return this;
        }

        public GetVaultResponse build() {
            return new GetVaultResponse(this.etag, this.opcRequestId, this.vault);
        }

        public String toString() {
            return "GetVaultResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", vault=" + this.vault + ")";
        }
    }
}

