/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.KeyVersionSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListKeyVersionsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<KeyVersionSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListKeyVersionsResponse(String opcNextPage, String opcRequestId, List<KeyVersionSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<KeyVersionSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<KeyVersionSummary> items;

        public Builder copy(ListKeyVersionsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<KeyVersionSummary> items) {
            this.items = items;
            return this;
        }

        public ListKeyVersionsResponse build() {
            return new ListKeyVersionsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListKeyVersionsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

