/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.KeySummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListKeysResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<KeySummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListKeysResponse(String opcNextPage, String opcRequestId, List<KeySummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<KeySummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<KeySummary> items;

        public Builder copy(ListKeysResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<KeySummary> items) {
            this.items = items;
            return this;
        }

        public ListKeysResponse build() {
            return new ListKeysResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListKeysResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

