/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.VaultSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListVaultsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<VaultSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListVaultsResponse(String opcNextPage, String opcRequestId, List<VaultSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<VaultSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<VaultSummary> items;

        public Builder copy(ListVaultsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<VaultSummary> items) {
            this.items = items;
            return this;
        }

        public ListVaultsResponse build() {
            return new ListVaultsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListVaultsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

