/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.limits.LimitsAsync;
import com.oracle.bmc.limits.internal.http.GetResourceAvailabilityConverter;
import com.oracle.bmc.limits.internal.http.ListLimitDefinitionsConverter;
import com.oracle.bmc.limits.internal.http.ListLimitValuesConverter;
import com.oracle.bmc.limits.internal.http.ListServicesConverter;
import com.oracle.bmc.limits.requests.GetResourceAvailabilityRequest;
import com.oracle.bmc.limits.requests.ListLimitDefinitionsRequest;
import com.oracle.bmc.limits.requests.ListLimitValuesRequest;
import com.oracle.bmc.limits.requests.ListServicesRequest;
import com.oracle.bmc.limits.responses.GetResourceAvailabilityResponse;
import com.oracle.bmc.limits.responses.ListLimitDefinitionsResponse;
import com.oracle.bmc.limits.responses.ListLimitValuesResponse;
import com.oracle.bmc.limits.responses.ListServicesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitsAsyncClient
implements LimitsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(LimitsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LIMITS").serviceEndpointPrefix("").serviceEndpointTemplate("https://limits.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public LimitsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public LimitsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public LimitsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public LimitsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public LimitsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public LimitsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public LimitsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<GetResourceAvailabilityResponse> getResourceAvailability(GetResourceAvailabilityRequest request, AsyncHandler<GetResourceAvailabilityRequest, GetResourceAvailabilityResponse> handler) {
        LOG.trace("Called async getResourceAvailability");
        final GetResourceAvailabilityRequest interceptedRequest = GetResourceAvailabilityConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetResourceAvailabilityConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetResourceAvailabilityResponse> transformer = GetResourceAvailabilityConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetResourceAvailabilityRequest, GetResourceAvailabilityResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetResourceAvailabilityRequest, GetResourceAvailabilityResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetResourceAvailabilityRequest, GetResourceAvailabilityResponse> onSuccess = new SuccessConsumer<GetResourceAvailabilityRequest, GetResourceAvailabilityResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetResourceAvailabilityRequest> onError = new ErrorConsumer<GetResourceAvailabilityRequest>(this, interceptedRequest);
                    LimitsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetResourceAvailabilityRequest, GetResourceAvailabilityResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetResourceAvailabilityRequest, GetResourceAvailabilityResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetResourceAvailabilityRequest> onError = handler == null ? null : new ErrorConsumer<GetResourceAvailabilityRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetResourceAvailabilityResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LimitsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetResourceAvailabilityResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListLimitDefinitionsResponse> listLimitDefinitions(ListLimitDefinitionsRequest request, AsyncHandler<ListLimitDefinitionsRequest, ListLimitDefinitionsResponse> handler) {
        LOG.trace("Called async listLimitDefinitions");
        final ListLimitDefinitionsRequest interceptedRequest = ListLimitDefinitionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListLimitDefinitionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListLimitDefinitionsResponse> transformer = ListLimitDefinitionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListLimitDefinitionsRequest, ListLimitDefinitionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListLimitDefinitionsRequest, ListLimitDefinitionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListLimitDefinitionsRequest, ListLimitDefinitionsResponse> onSuccess = new SuccessConsumer<ListLimitDefinitionsRequest, ListLimitDefinitionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListLimitDefinitionsRequest> onError = new ErrorConsumer<ListLimitDefinitionsRequest>(this, interceptedRequest);
                    LimitsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListLimitDefinitionsRequest, ListLimitDefinitionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListLimitDefinitionsRequest, ListLimitDefinitionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListLimitDefinitionsRequest> onError = handler == null ? null : new ErrorConsumer<ListLimitDefinitionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListLimitDefinitionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LimitsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListLimitDefinitionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListLimitValuesResponse> listLimitValues(ListLimitValuesRequest request, AsyncHandler<ListLimitValuesRequest, ListLimitValuesResponse> handler) {
        LOG.trace("Called async listLimitValues");
        final ListLimitValuesRequest interceptedRequest = ListLimitValuesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListLimitValuesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListLimitValuesResponse> transformer = ListLimitValuesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListLimitValuesRequest, ListLimitValuesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListLimitValuesRequest, ListLimitValuesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListLimitValuesRequest, ListLimitValuesResponse> onSuccess = new SuccessConsumer<ListLimitValuesRequest, ListLimitValuesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListLimitValuesRequest> onError = new ErrorConsumer<ListLimitValuesRequest>(this, interceptedRequest);
                    LimitsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListLimitValuesRequest, ListLimitValuesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListLimitValuesRequest, ListLimitValuesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListLimitValuesRequest> onError = handler == null ? null : new ErrorConsumer<ListLimitValuesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListLimitValuesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LimitsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListLimitValuesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListServicesResponse> listServices(ListServicesRequest request, AsyncHandler<ListServicesRequest, ListServicesResponse> handler) {
        LOG.trace("Called async listServices");
        final ListServicesRequest interceptedRequest = ListServicesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListServicesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListServicesResponse> transformer = ListServicesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListServicesRequest, ListServicesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListServicesRequest, ListServicesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListServicesRequest, ListServicesResponse> onSuccess = new SuccessConsumer<ListServicesRequest, ListServicesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListServicesRequest> onError = new ErrorConsumer<ListServicesRequest>(this, interceptedRequest);
                    LimitsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListServicesRequest, ListServicesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListServicesRequest, ListServicesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListServicesRequest> onError = handler == null ? null : new ErrorConsumer<ListServicesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListServicesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LimitsAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListServicesResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LimitsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public LimitsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new LimitsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

