/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.limits.QuotasAsync;
import com.oracle.bmc.limits.internal.http.CreateQuotaConverter;
import com.oracle.bmc.limits.internal.http.DeleteQuotaConverter;
import com.oracle.bmc.limits.internal.http.GetQuotaConverter;
import com.oracle.bmc.limits.internal.http.ListQuotasConverter;
import com.oracle.bmc.limits.internal.http.UpdateQuotaConverter;
import com.oracle.bmc.limits.requests.CreateQuotaRequest;
import com.oracle.bmc.limits.requests.DeleteQuotaRequest;
import com.oracle.bmc.limits.requests.GetQuotaRequest;
import com.oracle.bmc.limits.requests.ListQuotasRequest;
import com.oracle.bmc.limits.requests.UpdateQuotaRequest;
import com.oracle.bmc.limits.responses.CreateQuotaResponse;
import com.oracle.bmc.limits.responses.DeleteQuotaResponse;
import com.oracle.bmc.limits.responses.GetQuotaResponse;
import com.oracle.bmc.limits.responses.ListQuotasResponse;
import com.oracle.bmc.limits.responses.UpdateQuotaResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotasAsyncClient
implements QuotasAsync {
    private static final Logger LOG = LoggerFactory.getLogger(QuotasAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("QUOTAS").serviceEndpointPrefix("").serviceEndpointTemplate("https://limits.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public QuotasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public QuotasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public QuotasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public QuotasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public QuotasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public QuotasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public QuotasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateQuotaResponse> createQuota(CreateQuotaRequest request, AsyncHandler<CreateQuotaRequest, CreateQuotaResponse> handler) {
        LOG.trace("Called async createQuota");
        final CreateQuotaRequest interceptedRequest = CreateQuotaConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateQuotaConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateQuotaResponse> transformer = CreateQuotaConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateQuotaRequest, CreateQuotaResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateQuotaRequest, CreateQuotaResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateQuotaRequest, CreateQuotaResponse> onSuccess = new SuccessConsumer<CreateQuotaRequest, CreateQuotaResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateQuotaRequest> onError = new ErrorConsumer<CreateQuotaRequest>(this, interceptedRequest);
                    QuotasAsyncClient.this.client.post(ib, interceptedRequest.getCreateQuotaDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateQuotaRequest, CreateQuotaResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateQuotaRequest, CreateQuotaResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateQuotaRequest> onError = handler == null ? null : new ErrorConsumer<CreateQuotaRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateQuotaDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateQuotaResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return QuotasAsyncClient.this.client.post(ib, interceptedRequest.getCreateQuotaDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateQuotaResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteQuotaResponse> deleteQuota(DeleteQuotaRequest request, AsyncHandler<DeleteQuotaRequest, DeleteQuotaResponse> handler) {
        LOG.trace("Called async deleteQuota");
        final DeleteQuotaRequest interceptedRequest = DeleteQuotaConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteQuotaConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteQuotaResponse> transformer = DeleteQuotaConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteQuotaRequest, DeleteQuotaResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteQuotaRequest, DeleteQuotaResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteQuotaRequest, DeleteQuotaResponse> onSuccess = new SuccessConsumer<DeleteQuotaRequest, DeleteQuotaResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteQuotaRequest> onError = new ErrorConsumer<DeleteQuotaRequest>(this, interceptedRequest);
                    QuotasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteQuotaRequest, DeleteQuotaResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteQuotaRequest, DeleteQuotaResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteQuotaRequest> onError = handler == null ? null : new ErrorConsumer<DeleteQuotaRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteQuotaResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return QuotasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteQuotaResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetQuotaResponse> getQuota(GetQuotaRequest request, AsyncHandler<GetQuotaRequest, GetQuotaResponse> handler) {
        LOG.trace("Called async getQuota");
        final GetQuotaRequest interceptedRequest = GetQuotaConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetQuotaConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetQuotaResponse> transformer = GetQuotaConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetQuotaRequest, GetQuotaResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetQuotaRequest, GetQuotaResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetQuotaRequest, GetQuotaResponse> onSuccess = new SuccessConsumer<GetQuotaRequest, GetQuotaResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetQuotaRequest> onError = new ErrorConsumer<GetQuotaRequest>(this, interceptedRequest);
                    QuotasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetQuotaRequest, GetQuotaResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetQuotaRequest, GetQuotaResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetQuotaRequest> onError = handler == null ? null : new ErrorConsumer<GetQuotaRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetQuotaResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return QuotasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetQuotaResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListQuotasResponse> listQuotas(ListQuotasRequest request, AsyncHandler<ListQuotasRequest, ListQuotasResponse> handler) {
        LOG.trace("Called async listQuotas");
        final ListQuotasRequest interceptedRequest = ListQuotasConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListQuotasConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListQuotasResponse> transformer = ListQuotasConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListQuotasRequest, ListQuotasResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListQuotasRequest, ListQuotasResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListQuotasRequest, ListQuotasResponse> onSuccess = new SuccessConsumer<ListQuotasRequest, ListQuotasResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListQuotasRequest> onError = new ErrorConsumer<ListQuotasRequest>(this, interceptedRequest);
                    QuotasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListQuotasRequest, ListQuotasResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListQuotasRequest, ListQuotasResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListQuotasRequest> onError = handler == null ? null : new ErrorConsumer<ListQuotasRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListQuotasResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return QuotasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListQuotasResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateQuotaResponse> updateQuota(UpdateQuotaRequest request, AsyncHandler<UpdateQuotaRequest, UpdateQuotaResponse> handler) {
        LOG.trace("Called async updateQuota");
        final UpdateQuotaRequest interceptedRequest = UpdateQuotaConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateQuotaConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateQuotaResponse> transformer = UpdateQuotaConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateQuotaRequest, UpdateQuotaResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateQuotaRequest, UpdateQuotaResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateQuotaRequest, UpdateQuotaResponse> onSuccess = new SuccessConsumer<UpdateQuotaRequest, UpdateQuotaResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateQuotaRequest> onError = new ErrorConsumer<UpdateQuotaRequest>(this, interceptedRequest);
                    QuotasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateQuotaDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateQuotaRequest, UpdateQuotaResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateQuotaRequest, UpdateQuotaResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateQuotaRequest> onError = handler == null ? null : new ErrorConsumer<UpdateQuotaRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateQuotaDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateQuotaResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return QuotasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateQuotaDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateQuotaResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, QuotasAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public QuotasAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new QuotasAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

