/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.limits.Quotas;
import com.oracle.bmc.limits.model.QuotaSummary;
import com.oracle.bmc.limits.requests.ListQuotasRequest;
import com.oracle.bmc.limits.responses.ListQuotasResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class QuotasPaginators {
    private final Quotas client;

    public Iterable<ListQuotasResponse> listQuotasResponseIterator(final ListQuotasRequest request) {
        return new ResponseIterable<ListQuotasRequest.Builder, ListQuotasRequest, ListQuotasResponse>(new Supplier<ListQuotasRequest.Builder>(){

            public ListQuotasRequest.Builder get() {
                return ListQuotasRequest.builder().copy(request);
            }
        }, new Function<ListQuotasResponse, String>(){

            public String apply(ListQuotasResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListQuotasRequest.Builder>, ListQuotasRequest>(){

            public ListQuotasRequest apply(RequestBuilderAndToken<ListQuotasRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListQuotasRequest, ListQuotasResponse>(){

            public ListQuotasResponse apply(ListQuotasRequest request) {
                return QuotasPaginators.this.client.listQuotas(request);
            }
        });
    }

    public Iterable<QuotaSummary> listQuotasRecordIterator(final ListQuotasRequest request) {
        return new ResponseRecordIterable<ListQuotasRequest.Builder, ListQuotasRequest, ListQuotasResponse, QuotaSummary>(new Supplier<ListQuotasRequest.Builder>(){

            public ListQuotasRequest.Builder get() {
                return ListQuotasRequest.builder().copy(request);
            }
        }, new Function<ListQuotasResponse, String>(){

            public String apply(ListQuotasResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListQuotasRequest.Builder>, ListQuotasRequest>(){

            public ListQuotasRequest apply(RequestBuilderAndToken<ListQuotasRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListQuotasRequest, ListQuotasResponse>(){

            public ListQuotasResponse apply(ListQuotasRequest request) {
                return QuotasPaginators.this.client.listQuotas(request);
            }
        }, new Function<ListQuotasResponse, List<QuotaSummary>>(){

            public List<QuotaSummary> apply(ListQuotasResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public QuotasPaginators(Quotas client) {
        this.client = client;
    }
}

