/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.limits.Quotas;
import com.oracle.bmc.limits.model.Quota;
import com.oracle.bmc.limits.requests.GetQuotaRequest;
import com.oracle.bmc.limits.responses.GetQuotaResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class QuotasWaiters {
    private final ExecutorService executorService;
    private final Quotas client;

    public Waiter<GetQuotaRequest, GetQuotaResponse> forQuota(GetQuotaRequest request, Quota.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forQuota(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetQuotaRequest, GetQuotaResponse> forQuota(GetQuotaRequest request, Quota.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forQuota(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetQuotaRequest, GetQuotaResponse> forQuota(GetQuotaRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Quota.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forQuota(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetQuotaRequest, GetQuotaResponse> forQuota(BmcGenericWaiter waiter, GetQuotaRequest request, Quota.LifecycleState ... targetStates) {
        final HashSet<Quota.LifecycleState> targetStatesSet = new HashSet<Quota.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetQuotaRequest, GetQuotaResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetQuotaRequest, GetQuotaResponse>(){

            public GetQuotaResponse apply(GetQuotaRequest request) {
                return QuotasWaiters.this.client.getQuota(request);
            }
        }, new Predicate<GetQuotaResponse>(){

            public boolean apply(GetQuotaResponse response) {
                return targetStatesSet.contains((Object)response.getQuota().getLifecycleState());
            }
        }, false), request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public QuotasWaiters(ExecutorService executorService, Quotas client) {
        this.executorService = executorService;
        this.client = client;
    }
}

