/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.limits.model.ResourceAvailability;
import com.oracle.bmc.limits.requests.GetResourceAvailabilityRequest;
import com.oracle.bmc.limits.responses.GetResourceAvailabilityResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetResourceAvailabilityConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetResourceAvailabilityConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetResourceAvailabilityRequest interceptRequest(GetResourceAvailabilityRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetResourceAvailabilityRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getServiceName(), (String)"serviceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getLimitName(), (String)"limitName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("20190729").path("services").path(HttpUtils.encodePathSegment(request.getServiceName())).path("limits").path(HttpUtils.encodePathSegment(request.getLimitName())).path("resourceAvailability");
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getAvailabilityDomain() != null) {
            target = target.queryParam("availabilityDomain", HttpUtils.attemptEncodeQueryParam(request.getAvailabilityDomain()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetResourceAvailabilityResponse> fromResponse() {
        Function<Response, GetResourceAvailabilityResponse> transformer = new Function<Response, GetResourceAvailabilityResponse>(){

            public GetResourceAvailabilityResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetResourceAvailabilityResponse");
                Function<Response, WithHeaders<ResourceAvailability>> responseFn = RESPONSE_CONVERSION_FACTORY.create(ResourceAvailability.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetResourceAvailabilityResponse.Builder builder = GetResourceAvailabilityResponse.builder();
                builder.resourceAvailability((ResourceAvailability)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetResourceAvailabilityResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

