/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.limits.model.Quota;
import com.oracle.bmc.limits.requests.UpdateQuotaRequest;
import com.oracle.bmc.limits.responses.UpdateQuotaResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateQuotaConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateQuotaConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateQuotaRequest interceptRequest(UpdateQuotaRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateQuotaRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateQuotaDetails(), (String)"updateQuotaDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("20181025").path("quotas").path(HttpUtils.encodePathSegment(request.getQuotaId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdateQuotaResponse> fromResponse() {
        Function<Response, UpdateQuotaResponse> transformer = new Function<Response, UpdateQuotaResponse>(){

            public UpdateQuotaResponse apply(Response rawResponse) {
                Optional<List<String>> etagHeader;
                LOG.trace("Transform function invoked for UpdateQuotaResponse");
                Function<Response, WithHeaders<Quota>> responseFn = RESPONSE_CONVERSION_FACTORY.create(Quota.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateQuotaResponse.Builder builder = UpdateQuotaResponse.builder();
                builder.quota((Quota)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                UpdateQuotaResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

