/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetResourceAvailabilityRequest
extends BmcRequest {
    private String serviceName;
    private String limitName;
    private String compartmentId;
    private String availabilityDomain;
    private String opcRequestId;

    @ConstructorProperties(value={"serviceName", "limitName", "compartmentId", "availabilityDomain", "opcRequestId"})
    GetResourceAvailabilityRequest(String serviceName, String limitName, String compartmentId, String availabilityDomain, String opcRequestId) {
        this.serviceName = serviceName;
        this.limitName = limitName;
        this.compartmentId = compartmentId;
        this.availabilityDomain = availabilityDomain;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getLimitName() {
        return this.limitName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String serviceName;
        private String limitName;
        private String compartmentId;
        private String availabilityDomain;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResourceAvailabilityRequest o) {
            this.serviceName(o.getServiceName());
            this.limitName(o.getLimitName());
            this.compartmentId(o.getCompartmentId());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResourceAvailabilityRequest build() {
            GetResourceAvailabilityRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder limitName(String limitName) {
            this.limitName = limitName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetResourceAvailabilityRequest buildWithoutInvocationCallback() {
            return new GetResourceAvailabilityRequest(this.serviceName, this.limitName, this.compartmentId, this.availabilityDomain, this.opcRequestId);
        }

        public String toString() {
            return "GetResourceAvailabilityRequest.Builder(serviceName=" + this.serviceName + ", limitName=" + this.limitName + ", compartmentId=" + this.compartmentId + ", availabilityDomain=" + this.availabilityDomain + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

