/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListQuotasRequest
extends BmcRequest {
    private String compartmentId;
    private String page;
    private Integer limit;
    private String name;
    private LifecycleState lifecycleState;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "page", "limit", "name", "lifecycleState", "sortOrder", "sortBy", "opcRequestId"})
    ListQuotasRequest(String compartmentId, String page, Integer limit, String name, LifecycleState lifecycleState, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.page = page;
        this.limit = limit;
        this.name = name;
        this.lifecycleState = lifecycleState;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String compartmentId;
        private String page;
        private Integer limit;
        private String name;
        private LifecycleState lifecycleState;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListQuotasRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.name(o.getName());
            this.lifecycleState(o.getLifecycleState());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListQuotasRequest build() {
            ListQuotasRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListQuotasRequest buildWithoutInvocationCallback() {
            return new ListQuotasRequest(this.compartmentId, this.page, this.limit, this.name, this.lifecycleState, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListQuotasRequest.Builder(compartmentId=" + this.compartmentId + ", page=" + this.page + ", limit=" + this.limit + ", name=" + this.name + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        Name("NAME"),
        Timecreated("TIMECREATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState {
        Active("ACTIVE");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

