/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.responses;

import com.oracle.bmc.limits.model.Quota;
import java.beans.ConstructorProperties;

public class CreateQuotaResponse {
    private String opcRequestId;
    private String etag;
    private Quota quota;

    @ConstructorProperties(value={"opcRequestId", "etag", "quota"})
    CreateQuotaResponse(String opcRequestId, String etag, Quota quota) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.quota = quota;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Quota getQuota() {
        return this.quota;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Quota quota;

        public Builder copy(CreateQuotaResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.quota(o.getQuota());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder quota(Quota quota) {
            this.quota = quota;
            return this;
        }

        public CreateQuotaResponse build() {
            return new CreateQuotaResponse(this.opcRequestId, this.etag, this.quota);
        }

        public String toString() {
            return "CreateQuotaResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", quota=" + this.quota + ")";
        }
    }
}

