/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.responses;

import com.oracle.bmc.limits.model.ResourceAvailability;
import java.beans.ConstructorProperties;

public class GetResourceAvailabilityResponse {
    private String opcRequestId;
    private ResourceAvailability resourceAvailability;

    @ConstructorProperties(value={"opcRequestId", "resourceAvailability"})
    GetResourceAvailabilityResponse(String opcRequestId, ResourceAvailability resourceAvailability) {
        this.opcRequestId = opcRequestId;
        this.resourceAvailability = resourceAvailability;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ResourceAvailability getResourceAvailability() {
        return this.resourceAvailability;
    }

    public static class Builder {
        private String opcRequestId;
        private ResourceAvailability resourceAvailability;

        public Builder copy(GetResourceAvailabilityResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.resourceAvailability(o.getResourceAvailability());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder resourceAvailability(ResourceAvailability resourceAvailability) {
            this.resourceAvailability = resourceAvailability;
            return this;
        }

        public GetResourceAvailabilityResponse build() {
            return new GetResourceAvailabilityResponse(this.opcRequestId, this.resourceAvailability);
        }

        public String toString() {
            return "GetResourceAvailabilityResponse.Builder(opcRequestId=" + this.opcRequestId + ", resourceAvailability=" + this.resourceAvailability + ")";
        }
    }
}

