/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.responses;

import com.oracle.bmc.limits.model.LimitValueSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListLimitValuesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<LimitValueSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListLimitValuesResponse(String opcNextPage, String opcRequestId, List<LimitValueSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<LimitValueSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<LimitValueSummary> items;

        public Builder copy(ListLimitValuesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<LimitValueSummary> items) {
            this.items = items;
            return this;
        }

        public ListLimitValuesResponse build() {
            return new ListLimitValuesResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListLimitValuesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

