/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.responses;

import com.oracle.bmc.limits.model.QuotaSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListQuotasResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<QuotaSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListQuotasResponse(String opcNextPage, String opcRequestId, List<QuotaSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<QuotaSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<QuotaSummary> items;

        public Builder copy(ListQuotasResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<QuotaSummary> items) {
            this.items = items;
            return this;
        }

        public ListQuotasResponse build() {
            return new ListQuotasResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListQuotasResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

