/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.loadbalancer.LoadBalancerAsync;
import com.oracle.bmc.loadbalancer.internal.http.ChangeLoadBalancerCompartmentConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateCertificateConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateListenerConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreatePathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteCertificateConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteListenerConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeletePathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendHealthConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendSetHealthConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetHealthCheckerConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetLoadBalancerHealthConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetPathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListBackendSetsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListBackendsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListCertificatesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListHostnamesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListListenerRulesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListLoadBalancerHealthsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListLoadBalancersConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListPathRouteSetsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListPoliciesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListProtocolsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListRuleSetsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListShapesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateHealthCheckerConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateListenerConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateNetworkSecurityGroupsConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdatePathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateRuleSetConverter;
import com.oracle.bmc.loadbalancer.requests.ChangeLoadBalancerCompartmentRequest;
import com.oracle.bmc.loadbalancer.requests.CreateBackendRequest;
import com.oracle.bmc.loadbalancer.requests.CreateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.CreateHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.CreateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.CreateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.CreatePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteListenerRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.DeletePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetHealthCheckerRequest;
import com.oracle.bmc.loadbalancer.requests.GetHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.GetPathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetWorkRequestRequest;
import com.oracle.bmc.loadbalancer.requests.ListBackendSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListBackendsRequest;
import com.oracle.bmc.loadbalancer.requests.ListCertificatesRequest;
import com.oracle.bmc.loadbalancer.requests.ListHostnamesRequest;
import com.oracle.bmc.loadbalancer.requests.ListListenerRulesRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancerHealthsRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancersRequest;
import com.oracle.bmc.loadbalancer.requests.ListPathRouteSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListProtocolsRequest;
import com.oracle.bmc.loadbalancer.requests.ListRuleSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListShapesRequest;
import com.oracle.bmc.loadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateHealthCheckerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateNetworkSecurityGroupsRequest;
import com.oracle.bmc.loadbalancer.requests.UpdatePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateRuleSetRequest;
import com.oracle.bmc.loadbalancer.responses.ChangeLoadBalancerCompartmentResponse;
import com.oracle.bmc.loadbalancer.responses.CreateBackendResponse;
import com.oracle.bmc.loadbalancer.responses.CreateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.CreateHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.CreateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.CreateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.CreatePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteListenerResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.DeletePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetHealthCheckerResponse;
import com.oracle.bmc.loadbalancer.responses.GetHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.GetLoadBalancerHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.GetPathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetWorkRequestResponse;
import com.oracle.bmc.loadbalancer.responses.ListBackendSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListBackendsResponse;
import com.oracle.bmc.loadbalancer.responses.ListCertificatesResponse;
import com.oracle.bmc.loadbalancer.responses.ListHostnamesResponse;
import com.oracle.bmc.loadbalancer.responses.ListListenerRulesResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancerHealthsResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancersResponse;
import com.oracle.bmc.loadbalancer.responses.ListPathRouteSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListProtocolsResponse;
import com.oracle.bmc.loadbalancer.responses.ListRuleSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListShapesResponse;
import com.oracle.bmc.loadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateHealthCheckerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateNetworkSecurityGroupsResponse;
import com.oracle.bmc.loadbalancer.responses.UpdatePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateRuleSetResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerAsyncClient
implements LoadBalancerAsync {
    private static final Logger LOG = LoggerFactory.getLogger(LoadBalancerAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOADBALANCER").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public LoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public LoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public LoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeLoadBalancerCompartmentResponse> changeLoadBalancerCompartment(ChangeLoadBalancerCompartmentRequest request, AsyncHandler<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse> handler) {
        LOG.trace("Called async changeLoadBalancerCompartment");
        final ChangeLoadBalancerCompartmentRequest interceptedRequest = ChangeLoadBalancerCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeLoadBalancerCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeLoadBalancerCompartmentResponse> transformer = ChangeLoadBalancerCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse> onSuccess = new SuccessConsumer<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeLoadBalancerCompartmentRequest> onError = new ErrorConsumer<ChangeLoadBalancerCompartmentRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getChangeLoadBalancerCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeLoadBalancerCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeLoadBalancerCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeLoadBalancerCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeLoadBalancerCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getChangeLoadBalancerCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeLoadBalancerCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateBackendResponse> createBackend(CreateBackendRequest request, AsyncHandler<CreateBackendRequest, CreateBackendResponse> handler) {
        LOG.trace("Called async createBackend");
        final CreateBackendRequest interceptedRequest = CreateBackendConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateBackendConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateBackendResponse> transformer = CreateBackendConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateBackendRequest, CreateBackendResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateBackendRequest, CreateBackendResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateBackendRequest, CreateBackendResponse> onSuccess = new SuccessConsumer<CreateBackendRequest, CreateBackendResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateBackendRequest> onError = new ErrorConsumer<CreateBackendRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateBackendDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateBackendRequest, CreateBackendResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateBackendRequest, CreateBackendResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateBackendRequest> onError = handler == null ? null : new ErrorConsumer<CreateBackendRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateBackendDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateBackendResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateBackendDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateBackendResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateBackendSetResponse> createBackendSet(CreateBackendSetRequest request, AsyncHandler<CreateBackendSetRequest, CreateBackendSetResponse> handler) {
        LOG.trace("Called async createBackendSet");
        final CreateBackendSetRequest interceptedRequest = CreateBackendSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateBackendSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateBackendSetResponse> transformer = CreateBackendSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateBackendSetRequest, CreateBackendSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateBackendSetRequest, CreateBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateBackendSetRequest, CreateBackendSetResponse> onSuccess = new SuccessConsumer<CreateBackendSetRequest, CreateBackendSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateBackendSetRequest> onError = new ErrorConsumer<CreateBackendSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateBackendSetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateBackendSetRequest, CreateBackendSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateBackendSetRequest, CreateBackendSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateBackendSetRequest> onError = handler == null ? null : new ErrorConsumer<CreateBackendSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateBackendSetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateBackendSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateBackendSetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateBackendSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateCertificateResponse> createCertificate(CreateCertificateRequest request, AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handler) {
        LOG.trace("Called async createCertificate");
        final CreateCertificateRequest interceptedRequest = CreateCertificateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateCertificateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateCertificateResponse> transformer = CreateCertificateConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateCertificateRequest, CreateCertificateResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateCertificateRequest, CreateCertificateResponse> onSuccess = new SuccessConsumer<CreateCertificateRequest, CreateCertificateResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateCertificateRequest> onError = new ErrorConsumer<CreateCertificateRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateCertificateDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateCertificateRequest, CreateCertificateResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateCertificateRequest, CreateCertificateResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateCertificateRequest> onError = handler == null ? null : new ErrorConsumer<CreateCertificateRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateCertificateDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateCertificateResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateCertificateDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateCertificateResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateHostnameResponse> createHostname(CreateHostnameRequest request, AsyncHandler<CreateHostnameRequest, CreateHostnameResponse> handler) {
        LOG.trace("Called async createHostname");
        final CreateHostnameRequest interceptedRequest = CreateHostnameConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateHostnameConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateHostnameResponse> transformer = CreateHostnameConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateHostnameRequest, CreateHostnameResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateHostnameRequest, CreateHostnameResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateHostnameRequest, CreateHostnameResponse> onSuccess = new SuccessConsumer<CreateHostnameRequest, CreateHostnameResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateHostnameRequest> onError = new ErrorConsumer<CreateHostnameRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateHostnameDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateHostnameRequest, CreateHostnameResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateHostnameRequest, CreateHostnameResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateHostnameRequest> onError = handler == null ? null : new ErrorConsumer<CreateHostnameRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateHostnameDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateHostnameResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateHostnameDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateHostnameResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateListenerResponse> createListener(CreateListenerRequest request, AsyncHandler<CreateListenerRequest, CreateListenerResponse> handler) {
        LOG.trace("Called async createListener");
        final CreateListenerRequest interceptedRequest = CreateListenerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateListenerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateListenerResponse> transformer = CreateListenerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateListenerRequest, CreateListenerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateListenerRequest, CreateListenerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateListenerRequest, CreateListenerResponse> onSuccess = new SuccessConsumer<CreateListenerRequest, CreateListenerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateListenerRequest> onError = new ErrorConsumer<CreateListenerRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateListenerDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateListenerRequest, CreateListenerResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateListenerRequest, CreateListenerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateListenerRequest> onError = handler == null ? null : new ErrorConsumer<CreateListenerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateListenerDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateListenerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateListenerDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateListenerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest request, AsyncHandler<CreateLoadBalancerRequest, CreateLoadBalancerResponse> handler) {
        LOG.trace("Called async createLoadBalancer");
        final CreateLoadBalancerRequest interceptedRequest = CreateLoadBalancerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateLoadBalancerResponse> transformer = CreateLoadBalancerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateLoadBalancerRequest, CreateLoadBalancerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateLoadBalancerRequest, CreateLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateLoadBalancerRequest, CreateLoadBalancerResponse> onSuccess = new SuccessConsumer<CreateLoadBalancerRequest, CreateLoadBalancerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateLoadBalancerRequest> onError = new ErrorConsumer<CreateLoadBalancerRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateLoadBalancerRequest, CreateLoadBalancerResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateLoadBalancerRequest, CreateLoadBalancerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateLoadBalancerRequest> onError = handler == null ? null : new ErrorConsumer<CreateLoadBalancerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateLoadBalancerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateLoadBalancerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreatePathRouteSetResponse> createPathRouteSet(CreatePathRouteSetRequest request, AsyncHandler<CreatePathRouteSetRequest, CreatePathRouteSetResponse> handler) {
        LOG.trace("Called async createPathRouteSet");
        final CreatePathRouteSetRequest interceptedRequest = CreatePathRouteSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreatePathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreatePathRouteSetResponse> transformer = CreatePathRouteSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreatePathRouteSetRequest, CreatePathRouteSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreatePathRouteSetRequest, CreatePathRouteSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreatePathRouteSetRequest, CreatePathRouteSetResponse> onSuccess = new SuccessConsumer<CreatePathRouteSetRequest, CreatePathRouteSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreatePathRouteSetRequest> onError = new ErrorConsumer<CreatePathRouteSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreatePathRouteSetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreatePathRouteSetRequest, CreatePathRouteSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreatePathRouteSetRequest, CreatePathRouteSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreatePathRouteSetRequest> onError = handler == null ? null : new ErrorConsumer<CreatePathRouteSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreatePathRouteSetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreatePathRouteSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreatePathRouteSetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreatePathRouteSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateRuleSetResponse> createRuleSet(CreateRuleSetRequest request, AsyncHandler<CreateRuleSetRequest, CreateRuleSetResponse> handler) {
        LOG.trace("Called async createRuleSet");
        final CreateRuleSetRequest interceptedRequest = CreateRuleSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateRuleSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateRuleSetResponse> transformer = CreateRuleSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateRuleSetRequest, CreateRuleSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateRuleSetRequest, CreateRuleSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateRuleSetRequest, CreateRuleSetResponse> onSuccess = new SuccessConsumer<CreateRuleSetRequest, CreateRuleSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateRuleSetRequest> onError = new ErrorConsumer<CreateRuleSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateRuleSetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateRuleSetRequest, CreateRuleSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateRuleSetRequest, CreateRuleSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateRuleSetRequest> onError = handler == null ? null : new ErrorConsumer<CreateRuleSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateRuleSetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateRuleSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.post(ib, interceptedRequest.getCreateRuleSetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateRuleSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteBackendResponse> deleteBackend(DeleteBackendRequest request, AsyncHandler<DeleteBackendRequest, DeleteBackendResponse> handler) {
        LOG.trace("Called async deleteBackend");
        final DeleteBackendRequest interceptedRequest = DeleteBackendConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteBackendConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteBackendResponse> transformer = DeleteBackendConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteBackendRequest, DeleteBackendResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteBackendRequest, DeleteBackendResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteBackendRequest, DeleteBackendResponse> onSuccess = new SuccessConsumer<DeleteBackendRequest, DeleteBackendResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteBackendRequest> onError = new ErrorConsumer<DeleteBackendRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteBackendRequest, DeleteBackendResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteBackendRequest, DeleteBackendResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteBackendRequest> onError = handler == null ? null : new ErrorConsumer<DeleteBackendRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteBackendResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteBackendResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteBackendSetResponse> deleteBackendSet(DeleteBackendSetRequest request, AsyncHandler<DeleteBackendSetRequest, DeleteBackendSetResponse> handler) {
        LOG.trace("Called async deleteBackendSet");
        final DeleteBackendSetRequest interceptedRequest = DeleteBackendSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteBackendSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteBackendSetResponse> transformer = DeleteBackendSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteBackendSetRequest, DeleteBackendSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteBackendSetRequest, DeleteBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteBackendSetRequest, DeleteBackendSetResponse> onSuccess = new SuccessConsumer<DeleteBackendSetRequest, DeleteBackendSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteBackendSetRequest> onError = new ErrorConsumer<DeleteBackendSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteBackendSetRequest, DeleteBackendSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteBackendSetRequest, DeleteBackendSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteBackendSetRequest> onError = handler == null ? null : new ErrorConsumer<DeleteBackendSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteBackendSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteBackendSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest request, AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handler) {
        LOG.trace("Called async deleteCertificate");
        final DeleteCertificateRequest interceptedRequest = DeleteCertificateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteCertificateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteCertificateResponse> transformer = DeleteCertificateConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteCertificateRequest, DeleteCertificateResponse> onSuccess = new SuccessConsumer<DeleteCertificateRequest, DeleteCertificateResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteCertificateRequest> onError = new ErrorConsumer<DeleteCertificateRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteCertificateRequest, DeleteCertificateResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteCertificateRequest, DeleteCertificateResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteCertificateRequest> onError = handler == null ? null : new ErrorConsumer<DeleteCertificateRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteCertificateResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteCertificateResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteHostnameResponse> deleteHostname(DeleteHostnameRequest request, AsyncHandler<DeleteHostnameRequest, DeleteHostnameResponse> handler) {
        LOG.trace("Called async deleteHostname");
        final DeleteHostnameRequest interceptedRequest = DeleteHostnameConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteHostnameConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteHostnameResponse> transformer = DeleteHostnameConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteHostnameRequest, DeleteHostnameResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteHostnameRequest, DeleteHostnameResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteHostnameRequest, DeleteHostnameResponse> onSuccess = new SuccessConsumer<DeleteHostnameRequest, DeleteHostnameResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteHostnameRequest> onError = new ErrorConsumer<DeleteHostnameRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteHostnameRequest, DeleteHostnameResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteHostnameRequest, DeleteHostnameResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteHostnameRequest> onError = handler == null ? null : new ErrorConsumer<DeleteHostnameRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteHostnameResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteHostnameResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteListenerResponse> deleteListener(DeleteListenerRequest request, AsyncHandler<DeleteListenerRequest, DeleteListenerResponse> handler) {
        LOG.trace("Called async deleteListener");
        final DeleteListenerRequest interceptedRequest = DeleteListenerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteListenerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteListenerResponse> transformer = DeleteListenerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteListenerRequest, DeleteListenerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteListenerRequest, DeleteListenerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteListenerRequest, DeleteListenerResponse> onSuccess = new SuccessConsumer<DeleteListenerRequest, DeleteListenerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteListenerRequest> onError = new ErrorConsumer<DeleteListenerRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteListenerRequest, DeleteListenerResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteListenerRequest, DeleteListenerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteListenerRequest> onError = handler == null ? null : new ErrorConsumer<DeleteListenerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteListenerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteListenerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest request, AsyncHandler<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> handler) {
        LOG.trace("Called async deleteLoadBalancer");
        final DeleteLoadBalancerRequest interceptedRequest = DeleteLoadBalancerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteLoadBalancerResponse> transformer = DeleteLoadBalancerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> onSuccess = new SuccessConsumer<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteLoadBalancerRequest> onError = new ErrorConsumer<DeleteLoadBalancerRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteLoadBalancerRequest> onError = handler == null ? null : new ErrorConsumer<DeleteLoadBalancerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteLoadBalancerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteLoadBalancerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeletePathRouteSetResponse> deletePathRouteSet(DeletePathRouteSetRequest request, AsyncHandler<DeletePathRouteSetRequest, DeletePathRouteSetResponse> handler) {
        LOG.trace("Called async deletePathRouteSet");
        final DeletePathRouteSetRequest interceptedRequest = DeletePathRouteSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeletePathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeletePathRouteSetResponse> transformer = DeletePathRouteSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeletePathRouteSetRequest, DeletePathRouteSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeletePathRouteSetRequest, DeletePathRouteSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeletePathRouteSetRequest, DeletePathRouteSetResponse> onSuccess = new SuccessConsumer<DeletePathRouteSetRequest, DeletePathRouteSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeletePathRouteSetRequest> onError = new ErrorConsumer<DeletePathRouteSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeletePathRouteSetRequest, DeletePathRouteSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeletePathRouteSetRequest, DeletePathRouteSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeletePathRouteSetRequest> onError = handler == null ? null : new ErrorConsumer<DeletePathRouteSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeletePathRouteSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeletePathRouteSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteRuleSetResponse> deleteRuleSet(DeleteRuleSetRequest request, AsyncHandler<DeleteRuleSetRequest, DeleteRuleSetResponse> handler) {
        LOG.trace("Called async deleteRuleSet");
        final DeleteRuleSetRequest interceptedRequest = DeleteRuleSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteRuleSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteRuleSetResponse> transformer = DeleteRuleSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteRuleSetRequest, DeleteRuleSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteRuleSetRequest, DeleteRuleSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteRuleSetRequest, DeleteRuleSetResponse> onSuccess = new SuccessConsumer<DeleteRuleSetRequest, DeleteRuleSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteRuleSetRequest> onError = new ErrorConsumer<DeleteRuleSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteRuleSetRequest, DeleteRuleSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteRuleSetRequest, DeleteRuleSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteRuleSetRequest> onError = handler == null ? null : new ErrorConsumer<DeleteRuleSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteRuleSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteRuleSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBackendResponse> getBackend(GetBackendRequest request, AsyncHandler<GetBackendRequest, GetBackendResponse> handler) {
        LOG.trace("Called async getBackend");
        final GetBackendRequest interceptedRequest = GetBackendConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBackendConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBackendResponse> transformer = GetBackendConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBackendRequest, GetBackendResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBackendRequest, GetBackendResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBackendRequest, GetBackendResponse> onSuccess = new SuccessConsumer<GetBackendRequest, GetBackendResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBackendRequest> onError = new ErrorConsumer<GetBackendRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBackendRequest, GetBackendResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBackendRequest, GetBackendResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBackendRequest> onError = handler == null ? null : new ErrorConsumer<GetBackendRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBackendResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBackendResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBackendHealthResponse> getBackendHealth(GetBackendHealthRequest request, AsyncHandler<GetBackendHealthRequest, GetBackendHealthResponse> handler) {
        LOG.trace("Called async getBackendHealth");
        final GetBackendHealthRequest interceptedRequest = GetBackendHealthConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBackendHealthConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBackendHealthResponse> transformer = GetBackendHealthConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBackendHealthRequest, GetBackendHealthResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBackendHealthRequest, GetBackendHealthResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBackendHealthRequest, GetBackendHealthResponse> onSuccess = new SuccessConsumer<GetBackendHealthRequest, GetBackendHealthResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBackendHealthRequest> onError = new ErrorConsumer<GetBackendHealthRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBackendHealthRequest, GetBackendHealthResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBackendHealthRequest, GetBackendHealthResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBackendHealthRequest> onError = handler == null ? null : new ErrorConsumer<GetBackendHealthRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBackendHealthResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBackendHealthResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBackendSetResponse> getBackendSet(GetBackendSetRequest request, AsyncHandler<GetBackendSetRequest, GetBackendSetResponse> handler) {
        LOG.trace("Called async getBackendSet");
        final GetBackendSetRequest interceptedRequest = GetBackendSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBackendSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBackendSetResponse> transformer = GetBackendSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBackendSetRequest, GetBackendSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBackendSetRequest, GetBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBackendSetRequest, GetBackendSetResponse> onSuccess = new SuccessConsumer<GetBackendSetRequest, GetBackendSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBackendSetRequest> onError = new ErrorConsumer<GetBackendSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBackendSetRequest, GetBackendSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBackendSetRequest, GetBackendSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBackendSetRequest> onError = handler == null ? null : new ErrorConsumer<GetBackendSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBackendSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBackendSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBackendSetHealthResponse> getBackendSetHealth(GetBackendSetHealthRequest request, AsyncHandler<GetBackendSetHealthRequest, GetBackendSetHealthResponse> handler) {
        LOG.trace("Called async getBackendSetHealth");
        final GetBackendSetHealthRequest interceptedRequest = GetBackendSetHealthConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBackendSetHealthConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBackendSetHealthResponse> transformer = GetBackendSetHealthConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBackendSetHealthRequest, GetBackendSetHealthResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBackendSetHealthRequest, GetBackendSetHealthResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBackendSetHealthRequest, GetBackendSetHealthResponse> onSuccess = new SuccessConsumer<GetBackendSetHealthRequest, GetBackendSetHealthResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBackendSetHealthRequest> onError = new ErrorConsumer<GetBackendSetHealthRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBackendSetHealthRequest, GetBackendSetHealthResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBackendSetHealthRequest, GetBackendSetHealthResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBackendSetHealthRequest> onError = handler == null ? null : new ErrorConsumer<GetBackendSetHealthRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBackendSetHealthResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBackendSetHealthResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetHealthCheckerResponse> getHealthChecker(GetHealthCheckerRequest request, AsyncHandler<GetHealthCheckerRequest, GetHealthCheckerResponse> handler) {
        LOG.trace("Called async getHealthChecker");
        final GetHealthCheckerRequest interceptedRequest = GetHealthCheckerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetHealthCheckerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetHealthCheckerResponse> transformer = GetHealthCheckerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetHealthCheckerRequest, GetHealthCheckerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetHealthCheckerRequest, GetHealthCheckerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetHealthCheckerRequest, GetHealthCheckerResponse> onSuccess = new SuccessConsumer<GetHealthCheckerRequest, GetHealthCheckerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetHealthCheckerRequest> onError = new ErrorConsumer<GetHealthCheckerRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetHealthCheckerRequest, GetHealthCheckerResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetHealthCheckerRequest, GetHealthCheckerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetHealthCheckerRequest> onError = handler == null ? null : new ErrorConsumer<GetHealthCheckerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetHealthCheckerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetHealthCheckerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetHostnameResponse> getHostname(GetHostnameRequest request, AsyncHandler<GetHostnameRequest, GetHostnameResponse> handler) {
        LOG.trace("Called async getHostname");
        final GetHostnameRequest interceptedRequest = GetHostnameConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetHostnameConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetHostnameResponse> transformer = GetHostnameConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetHostnameRequest, GetHostnameResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetHostnameRequest, GetHostnameResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetHostnameRequest, GetHostnameResponse> onSuccess = new SuccessConsumer<GetHostnameRequest, GetHostnameResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetHostnameRequest> onError = new ErrorConsumer<GetHostnameRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetHostnameRequest, GetHostnameResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetHostnameRequest, GetHostnameResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetHostnameRequest> onError = handler == null ? null : new ErrorConsumer<GetHostnameRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetHostnameResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetHostnameResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetLoadBalancerResponse> getLoadBalancer(GetLoadBalancerRequest request, AsyncHandler<GetLoadBalancerRequest, GetLoadBalancerResponse> handler) {
        LOG.trace("Called async getLoadBalancer");
        final GetLoadBalancerRequest interceptedRequest = GetLoadBalancerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetLoadBalancerResponse> transformer = GetLoadBalancerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetLoadBalancerRequest, GetLoadBalancerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetLoadBalancerRequest, GetLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetLoadBalancerRequest, GetLoadBalancerResponse> onSuccess = new SuccessConsumer<GetLoadBalancerRequest, GetLoadBalancerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetLoadBalancerRequest> onError = new ErrorConsumer<GetLoadBalancerRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetLoadBalancerRequest, GetLoadBalancerResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetLoadBalancerRequest, GetLoadBalancerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetLoadBalancerRequest> onError = handler == null ? null : new ErrorConsumer<GetLoadBalancerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetLoadBalancerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetLoadBalancerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetLoadBalancerHealthResponse> getLoadBalancerHealth(GetLoadBalancerHealthRequest request, AsyncHandler<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse> handler) {
        LOG.trace("Called async getLoadBalancerHealth");
        final GetLoadBalancerHealthRequest interceptedRequest = GetLoadBalancerHealthConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetLoadBalancerHealthConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetLoadBalancerHealthResponse> transformer = GetLoadBalancerHealthConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse> onSuccess = new SuccessConsumer<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetLoadBalancerHealthRequest> onError = new ErrorConsumer<GetLoadBalancerHealthRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetLoadBalancerHealthRequest> onError = handler == null ? null : new ErrorConsumer<GetLoadBalancerHealthRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetLoadBalancerHealthResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetLoadBalancerHealthResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetPathRouteSetResponse> getPathRouteSet(GetPathRouteSetRequest request, AsyncHandler<GetPathRouteSetRequest, GetPathRouteSetResponse> handler) {
        LOG.trace("Called async getPathRouteSet");
        final GetPathRouteSetRequest interceptedRequest = GetPathRouteSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetPathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetPathRouteSetResponse> transformer = GetPathRouteSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetPathRouteSetRequest, GetPathRouteSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetPathRouteSetRequest, GetPathRouteSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetPathRouteSetRequest, GetPathRouteSetResponse> onSuccess = new SuccessConsumer<GetPathRouteSetRequest, GetPathRouteSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetPathRouteSetRequest> onError = new ErrorConsumer<GetPathRouteSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetPathRouteSetRequest, GetPathRouteSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetPathRouteSetRequest, GetPathRouteSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetPathRouteSetRequest> onError = handler == null ? null : new ErrorConsumer<GetPathRouteSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetPathRouteSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetPathRouteSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetRuleSetResponse> getRuleSet(GetRuleSetRequest request, AsyncHandler<GetRuleSetRequest, GetRuleSetResponse> handler) {
        LOG.trace("Called async getRuleSet");
        final GetRuleSetRequest interceptedRequest = GetRuleSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetRuleSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetRuleSetResponse> transformer = GetRuleSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetRuleSetRequest, GetRuleSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetRuleSetRequest, GetRuleSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetRuleSetRequest, GetRuleSetResponse> onSuccess = new SuccessConsumer<GetRuleSetRequest, GetRuleSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetRuleSetRequest> onError = new ErrorConsumer<GetRuleSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetRuleSetRequest, GetRuleSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetRuleSetRequest, GetRuleSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetRuleSetRequest> onError = handler == null ? null : new ErrorConsumer<GetRuleSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetRuleSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetRuleSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        final GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWorkRequestRequest> onError = new ErrorConsumer<GetWorkRequestRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<GetWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListBackendSetsResponse> listBackendSets(ListBackendSetsRequest request, AsyncHandler<ListBackendSetsRequest, ListBackendSetsResponse> handler) {
        LOG.trace("Called async listBackendSets");
        final ListBackendSetsRequest interceptedRequest = ListBackendSetsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListBackendSetsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListBackendSetsResponse> transformer = ListBackendSetsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListBackendSetsRequest, ListBackendSetsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListBackendSetsRequest, ListBackendSetsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListBackendSetsRequest, ListBackendSetsResponse> onSuccess = new SuccessConsumer<ListBackendSetsRequest, ListBackendSetsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListBackendSetsRequest> onError = new ErrorConsumer<ListBackendSetsRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListBackendSetsRequest, ListBackendSetsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListBackendSetsRequest, ListBackendSetsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListBackendSetsRequest> onError = handler == null ? null : new ErrorConsumer<ListBackendSetsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListBackendSetsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListBackendSetsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListBackendsResponse> listBackends(ListBackendsRequest request, AsyncHandler<ListBackendsRequest, ListBackendsResponse> handler) {
        LOG.trace("Called async listBackends");
        final ListBackendsRequest interceptedRequest = ListBackendsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListBackendsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListBackendsResponse> transformer = ListBackendsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListBackendsRequest, ListBackendsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListBackendsRequest, ListBackendsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListBackendsRequest, ListBackendsResponse> onSuccess = new SuccessConsumer<ListBackendsRequest, ListBackendsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListBackendsRequest> onError = new ErrorConsumer<ListBackendsRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListBackendsRequest, ListBackendsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListBackendsRequest, ListBackendsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListBackendsRequest> onError = handler == null ? null : new ErrorConsumer<ListBackendsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListBackendsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListBackendsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCertificatesResponse> listCertificates(ListCertificatesRequest request, AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handler) {
        LOG.trace("Called async listCertificates");
        final ListCertificatesRequest interceptedRequest = ListCertificatesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCertificatesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCertificatesResponse> transformer = ListCertificatesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCertificatesRequest, ListCertificatesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCertificatesRequest, ListCertificatesResponse> onSuccess = new SuccessConsumer<ListCertificatesRequest, ListCertificatesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCertificatesRequest> onError = new ErrorConsumer<ListCertificatesRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCertificatesRequest, ListCertificatesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCertificatesRequest, ListCertificatesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCertificatesRequest> onError = handler == null ? null : new ErrorConsumer<ListCertificatesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCertificatesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCertificatesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListHostnamesResponse> listHostnames(ListHostnamesRequest request, AsyncHandler<ListHostnamesRequest, ListHostnamesResponse> handler) {
        LOG.trace("Called async listHostnames");
        final ListHostnamesRequest interceptedRequest = ListHostnamesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListHostnamesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListHostnamesResponse> transformer = ListHostnamesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListHostnamesRequest, ListHostnamesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListHostnamesRequest, ListHostnamesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListHostnamesRequest, ListHostnamesResponse> onSuccess = new SuccessConsumer<ListHostnamesRequest, ListHostnamesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListHostnamesRequest> onError = new ErrorConsumer<ListHostnamesRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListHostnamesRequest, ListHostnamesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListHostnamesRequest, ListHostnamesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListHostnamesRequest> onError = handler == null ? null : new ErrorConsumer<ListHostnamesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListHostnamesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListHostnamesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListListenerRulesResponse> listListenerRules(ListListenerRulesRequest request, AsyncHandler<ListListenerRulesRequest, ListListenerRulesResponse> handler) {
        LOG.trace("Called async listListenerRules");
        final ListListenerRulesRequest interceptedRequest = ListListenerRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListListenerRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListListenerRulesResponse> transformer = ListListenerRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListListenerRulesRequest, ListListenerRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListListenerRulesRequest, ListListenerRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListListenerRulesRequest, ListListenerRulesResponse> onSuccess = new SuccessConsumer<ListListenerRulesRequest, ListListenerRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListListenerRulesRequest> onError = new ErrorConsumer<ListListenerRulesRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListListenerRulesRequest, ListListenerRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListListenerRulesRequest, ListListenerRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListListenerRulesRequest> onError = handler == null ? null : new ErrorConsumer<ListListenerRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListListenerRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListListenerRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListLoadBalancerHealthsResponse> listLoadBalancerHealths(ListLoadBalancerHealthsRequest request, AsyncHandler<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse> handler) {
        LOG.trace("Called async listLoadBalancerHealths");
        final ListLoadBalancerHealthsRequest interceptedRequest = ListLoadBalancerHealthsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListLoadBalancerHealthsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListLoadBalancerHealthsResponse> transformer = ListLoadBalancerHealthsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse> onSuccess = new SuccessConsumer<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListLoadBalancerHealthsRequest> onError = new ErrorConsumer<ListLoadBalancerHealthsRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListLoadBalancerHealthsRequest> onError = handler == null ? null : new ErrorConsumer<ListLoadBalancerHealthsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListLoadBalancerHealthsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListLoadBalancerHealthsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListLoadBalancersResponse> listLoadBalancers(ListLoadBalancersRequest request, AsyncHandler<ListLoadBalancersRequest, ListLoadBalancersResponse> handler) {
        LOG.trace("Called async listLoadBalancers");
        final ListLoadBalancersRequest interceptedRequest = ListLoadBalancersConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListLoadBalancersConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListLoadBalancersResponse> transformer = ListLoadBalancersConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListLoadBalancersRequest, ListLoadBalancersResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListLoadBalancersRequest, ListLoadBalancersResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListLoadBalancersRequest, ListLoadBalancersResponse> onSuccess = new SuccessConsumer<ListLoadBalancersRequest, ListLoadBalancersResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListLoadBalancersRequest> onError = new ErrorConsumer<ListLoadBalancersRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListLoadBalancersRequest, ListLoadBalancersResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListLoadBalancersRequest, ListLoadBalancersResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListLoadBalancersRequest> onError = handler == null ? null : new ErrorConsumer<ListLoadBalancersRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListLoadBalancersResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListLoadBalancersResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListPathRouteSetsResponse> listPathRouteSets(ListPathRouteSetsRequest request, AsyncHandler<ListPathRouteSetsRequest, ListPathRouteSetsResponse> handler) {
        LOG.trace("Called async listPathRouteSets");
        final ListPathRouteSetsRequest interceptedRequest = ListPathRouteSetsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListPathRouteSetsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListPathRouteSetsResponse> transformer = ListPathRouteSetsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListPathRouteSetsRequest, ListPathRouteSetsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListPathRouteSetsRequest, ListPathRouteSetsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListPathRouteSetsRequest, ListPathRouteSetsResponse> onSuccess = new SuccessConsumer<ListPathRouteSetsRequest, ListPathRouteSetsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListPathRouteSetsRequest> onError = new ErrorConsumer<ListPathRouteSetsRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListPathRouteSetsRequest, ListPathRouteSetsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListPathRouteSetsRequest, ListPathRouteSetsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListPathRouteSetsRequest> onError = handler == null ? null : new ErrorConsumer<ListPathRouteSetsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListPathRouteSetsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListPathRouteSetsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListPoliciesResponse> listPolicies(ListPoliciesRequest request, AsyncHandler<ListPoliciesRequest, ListPoliciesResponse> handler) {
        LOG.trace("Called async listPolicies");
        final ListPoliciesRequest interceptedRequest = ListPoliciesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListPoliciesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListPoliciesResponse> transformer = ListPoliciesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListPoliciesRequest, ListPoliciesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListPoliciesRequest, ListPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListPoliciesRequest, ListPoliciesResponse> onSuccess = new SuccessConsumer<ListPoliciesRequest, ListPoliciesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListPoliciesRequest> onError = new ErrorConsumer<ListPoliciesRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListPoliciesRequest, ListPoliciesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListPoliciesRequest, ListPoliciesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListPoliciesRequest> onError = handler == null ? null : new ErrorConsumer<ListPoliciesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListPoliciesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListPoliciesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListProtocolsResponse> listProtocols(ListProtocolsRequest request, AsyncHandler<ListProtocolsRequest, ListProtocolsResponse> handler) {
        LOG.trace("Called async listProtocols");
        final ListProtocolsRequest interceptedRequest = ListProtocolsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListProtocolsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListProtocolsResponse> transformer = ListProtocolsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListProtocolsRequest, ListProtocolsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListProtocolsRequest, ListProtocolsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListProtocolsRequest, ListProtocolsResponse> onSuccess = new SuccessConsumer<ListProtocolsRequest, ListProtocolsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListProtocolsRequest> onError = new ErrorConsumer<ListProtocolsRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListProtocolsRequest, ListProtocolsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListProtocolsRequest, ListProtocolsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListProtocolsRequest> onError = handler == null ? null : new ErrorConsumer<ListProtocolsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListProtocolsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListProtocolsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListRuleSetsResponse> listRuleSets(ListRuleSetsRequest request, AsyncHandler<ListRuleSetsRequest, ListRuleSetsResponse> handler) {
        LOG.trace("Called async listRuleSets");
        final ListRuleSetsRequest interceptedRequest = ListRuleSetsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListRuleSetsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListRuleSetsResponse> transformer = ListRuleSetsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListRuleSetsRequest, ListRuleSetsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListRuleSetsRequest, ListRuleSetsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListRuleSetsRequest, ListRuleSetsResponse> onSuccess = new SuccessConsumer<ListRuleSetsRequest, ListRuleSetsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListRuleSetsRequest> onError = new ErrorConsumer<ListRuleSetsRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListRuleSetsRequest, ListRuleSetsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListRuleSetsRequest, ListRuleSetsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListRuleSetsRequest> onError = handler == null ? null : new ErrorConsumer<ListRuleSetsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListRuleSetsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListRuleSetsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListShapesResponse> listShapes(ListShapesRequest request, AsyncHandler<ListShapesRequest, ListShapesResponse> handler) {
        LOG.trace("Called async listShapes");
        final ListShapesRequest interceptedRequest = ListShapesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListShapesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListShapesResponse> transformer = ListShapesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListShapesRequest, ListShapesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListShapesRequest, ListShapesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListShapesRequest, ListShapesResponse> onSuccess = new SuccessConsumer<ListShapesRequest, ListShapesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListShapesRequest> onError = new ErrorConsumer<ListShapesRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListShapesRequest, ListShapesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListShapesRequest, ListShapesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListShapesRequest> onError = handler == null ? null : new ErrorConsumer<ListShapesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListShapesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListShapesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        final ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestsRequest> onError = new ErrorConsumer<ListWorkRequestsRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateBackendResponse> updateBackend(UpdateBackendRequest request, AsyncHandler<UpdateBackendRequest, UpdateBackendResponse> handler) {
        LOG.trace("Called async updateBackend");
        final UpdateBackendRequest interceptedRequest = UpdateBackendConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateBackendConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateBackendResponse> transformer = UpdateBackendConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateBackendRequest, UpdateBackendResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateBackendRequest, UpdateBackendResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateBackendRequest, UpdateBackendResponse> onSuccess = new SuccessConsumer<UpdateBackendRequest, UpdateBackendResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateBackendRequest> onError = new ErrorConsumer<UpdateBackendRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBackendDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateBackendRequest, UpdateBackendResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateBackendRequest, UpdateBackendResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateBackendRequest> onError = handler == null ? null : new ErrorConsumer<UpdateBackendRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateBackendDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateBackendResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBackendDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateBackendResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateBackendSetResponse> updateBackendSet(UpdateBackendSetRequest request, AsyncHandler<UpdateBackendSetRequest, UpdateBackendSetResponse> handler) {
        LOG.trace("Called async updateBackendSet");
        final UpdateBackendSetRequest interceptedRequest = UpdateBackendSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateBackendSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateBackendSetResponse> transformer = UpdateBackendSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateBackendSetRequest, UpdateBackendSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateBackendSetRequest, UpdateBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateBackendSetRequest, UpdateBackendSetResponse> onSuccess = new SuccessConsumer<UpdateBackendSetRequest, UpdateBackendSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateBackendSetRequest> onError = new ErrorConsumer<UpdateBackendSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBackendSetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateBackendSetRequest, UpdateBackendSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateBackendSetRequest, UpdateBackendSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateBackendSetRequest> onError = handler == null ? null : new ErrorConsumer<UpdateBackendSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateBackendSetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateBackendSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBackendSetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateBackendSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateHealthCheckerResponse> updateHealthChecker(UpdateHealthCheckerRequest request, AsyncHandler<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse> handler) {
        LOG.trace("Called async updateHealthChecker");
        final UpdateHealthCheckerRequest interceptedRequest = UpdateHealthCheckerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateHealthCheckerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateHealthCheckerResponse> transformer = UpdateHealthCheckerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse> onSuccess = new SuccessConsumer<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateHealthCheckerRequest> onError = new ErrorConsumer<UpdateHealthCheckerRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getHealthChecker(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateHealthCheckerRequest> onError = handler == null ? null : new ErrorConsumer<UpdateHealthCheckerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getHealthChecker(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateHealthCheckerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getHealthChecker(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateHealthCheckerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateHostnameResponse> updateHostname(UpdateHostnameRequest request, AsyncHandler<UpdateHostnameRequest, UpdateHostnameResponse> handler) {
        LOG.trace("Called async updateHostname");
        final UpdateHostnameRequest interceptedRequest = UpdateHostnameConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateHostnameConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateHostnameResponse> transformer = UpdateHostnameConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateHostnameRequest, UpdateHostnameResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateHostnameRequest, UpdateHostnameResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateHostnameRequest, UpdateHostnameResponse> onSuccess = new SuccessConsumer<UpdateHostnameRequest, UpdateHostnameResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateHostnameRequest> onError = new ErrorConsumer<UpdateHostnameRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateHostnameDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateHostnameRequest, UpdateHostnameResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateHostnameRequest, UpdateHostnameResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateHostnameRequest> onError = handler == null ? null : new ErrorConsumer<UpdateHostnameRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateHostnameDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateHostnameResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateHostnameDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateHostnameResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateListenerResponse> updateListener(UpdateListenerRequest request, AsyncHandler<UpdateListenerRequest, UpdateListenerResponse> handler) {
        LOG.trace("Called async updateListener");
        final UpdateListenerRequest interceptedRequest = UpdateListenerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateListenerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateListenerResponse> transformer = UpdateListenerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateListenerRequest, UpdateListenerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateListenerRequest, UpdateListenerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateListenerRequest, UpdateListenerResponse> onSuccess = new SuccessConsumer<UpdateListenerRequest, UpdateListenerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateListenerRequest> onError = new ErrorConsumer<UpdateListenerRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateListenerDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateListenerRequest, UpdateListenerResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateListenerRequest, UpdateListenerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateListenerRequest> onError = handler == null ? null : new ErrorConsumer<UpdateListenerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateListenerDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateListenerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateListenerDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateListenerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateLoadBalancerResponse> updateLoadBalancer(UpdateLoadBalancerRequest request, AsyncHandler<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse> handler) {
        LOG.trace("Called async updateLoadBalancer");
        final UpdateLoadBalancerRequest interceptedRequest = UpdateLoadBalancerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateLoadBalancerResponse> transformer = UpdateLoadBalancerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse> onSuccess = new SuccessConsumer<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateLoadBalancerRequest> onError = new ErrorConsumer<UpdateLoadBalancerRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateLoadBalancerRequest> onError = handler == null ? null : new ErrorConsumer<UpdateLoadBalancerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateLoadBalancerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateLoadBalancerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateNetworkSecurityGroupsResponse> updateNetworkSecurityGroups(UpdateNetworkSecurityGroupsRequest request, AsyncHandler<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse> handler) {
        LOG.trace("Called async updateNetworkSecurityGroups");
        final UpdateNetworkSecurityGroupsRequest interceptedRequest = UpdateNetworkSecurityGroupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateNetworkSecurityGroupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateNetworkSecurityGroupsResponse> transformer = UpdateNetworkSecurityGroupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse> onSuccess = new SuccessConsumer<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateNetworkSecurityGroupsRequest> onError = new ErrorConsumer<UpdateNetworkSecurityGroupsRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateNetworkSecurityGroupsDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateNetworkSecurityGroupsRequest> onError = handler == null ? null : new ErrorConsumer<UpdateNetworkSecurityGroupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateNetworkSecurityGroupsDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateNetworkSecurityGroupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateNetworkSecurityGroupsDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateNetworkSecurityGroupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdatePathRouteSetResponse> updatePathRouteSet(UpdatePathRouteSetRequest request, AsyncHandler<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse> handler) {
        LOG.trace("Called async updatePathRouteSet");
        final UpdatePathRouteSetRequest interceptedRequest = UpdatePathRouteSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdatePathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdatePathRouteSetResponse> transformer = UpdatePathRouteSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse> onSuccess = new SuccessConsumer<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdatePathRouteSetRequest> onError = new ErrorConsumer<UpdatePathRouteSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePathRouteSetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdatePathRouteSetRequest> onError = handler == null ? null : new ErrorConsumer<UpdatePathRouteSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdatePathRouteSetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdatePathRouteSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePathRouteSetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdatePathRouteSetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateRuleSetResponse> updateRuleSet(UpdateRuleSetRequest request, AsyncHandler<UpdateRuleSetRequest, UpdateRuleSetResponse> handler) {
        LOG.trace("Called async updateRuleSet");
        final UpdateRuleSetRequest interceptedRequest = UpdateRuleSetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateRuleSetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateRuleSetResponse> transformer = UpdateRuleSetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateRuleSetRequest, UpdateRuleSetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateRuleSetRequest, UpdateRuleSetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateRuleSetRequest, UpdateRuleSetResponse> onSuccess = new SuccessConsumer<UpdateRuleSetRequest, UpdateRuleSetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateRuleSetRequest> onError = new ErrorConsumer<UpdateRuleSetRequest>(this, interceptedRequest);
                    LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateRuleSetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateRuleSetRequest, UpdateRuleSetResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateRuleSetRequest, UpdateRuleSetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateRuleSetRequest> onError = handler == null ? null : new ErrorConsumer<UpdateRuleSetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateRuleSetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateRuleSetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return LoadBalancerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateRuleSetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateRuleSetResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LoadBalancerAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public LoadBalancerAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new LoadBalancerAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

