/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.loadbalancer.LoadBalancer;
import com.oracle.bmc.loadbalancer.model.LoadBalancerHealthSummary;
import com.oracle.bmc.loadbalancer.model.LoadBalancerPolicy;
import com.oracle.bmc.loadbalancer.model.LoadBalancerProtocol;
import com.oracle.bmc.loadbalancer.model.LoadBalancerShape;
import com.oracle.bmc.loadbalancer.model.WorkRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancerHealthsRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancersRequest;
import com.oracle.bmc.loadbalancer.requests.ListPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListProtocolsRequest;
import com.oracle.bmc.loadbalancer.requests.ListShapesRequest;
import com.oracle.bmc.loadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancerHealthsResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancersResponse;
import com.oracle.bmc.loadbalancer.responses.ListPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListProtocolsResponse;
import com.oracle.bmc.loadbalancer.responses.ListShapesResponse;
import com.oracle.bmc.loadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class LoadBalancerPaginators {
    private final LoadBalancer client;

    public Iterable<ListLoadBalancerHealthsResponse> listLoadBalancerHealthsResponseIterator(final ListLoadBalancerHealthsRequest request) {
        return new ResponseIterable<ListLoadBalancerHealthsRequest.Builder, ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse>(new Supplier<ListLoadBalancerHealthsRequest.Builder>(){

            public ListLoadBalancerHealthsRequest.Builder get() {
                return ListLoadBalancerHealthsRequest.builder().copy(request);
            }
        }, new Function<ListLoadBalancerHealthsResponse, String>(){

            public String apply(ListLoadBalancerHealthsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListLoadBalancerHealthsRequest.Builder>, ListLoadBalancerHealthsRequest>(){

            public ListLoadBalancerHealthsRequest apply(RequestBuilderAndToken<ListLoadBalancerHealthsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse>(){

            public ListLoadBalancerHealthsResponse apply(ListLoadBalancerHealthsRequest request) {
                return LoadBalancerPaginators.this.client.listLoadBalancerHealths(request);
            }
        });
    }

    public Iterable<LoadBalancerHealthSummary> listLoadBalancerHealthsRecordIterator(final ListLoadBalancerHealthsRequest request) {
        return new ResponseRecordIterable<ListLoadBalancerHealthsRequest.Builder, ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse, LoadBalancerHealthSummary>(new Supplier<ListLoadBalancerHealthsRequest.Builder>(){

            public ListLoadBalancerHealthsRequest.Builder get() {
                return ListLoadBalancerHealthsRequest.builder().copy(request);
            }
        }, new Function<ListLoadBalancerHealthsResponse, String>(){

            public String apply(ListLoadBalancerHealthsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListLoadBalancerHealthsRequest.Builder>, ListLoadBalancerHealthsRequest>(){

            public ListLoadBalancerHealthsRequest apply(RequestBuilderAndToken<ListLoadBalancerHealthsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse>(){

            public ListLoadBalancerHealthsResponse apply(ListLoadBalancerHealthsRequest request) {
                return LoadBalancerPaginators.this.client.listLoadBalancerHealths(request);
            }
        }, new Function<ListLoadBalancerHealthsResponse, List<LoadBalancerHealthSummary>>(){

            public List<LoadBalancerHealthSummary> apply(ListLoadBalancerHealthsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListLoadBalancersResponse> listLoadBalancersResponseIterator(final ListLoadBalancersRequest request) {
        return new ResponseIterable<ListLoadBalancersRequest.Builder, ListLoadBalancersRequest, ListLoadBalancersResponse>(new Supplier<ListLoadBalancersRequest.Builder>(){

            public ListLoadBalancersRequest.Builder get() {
                return ListLoadBalancersRequest.builder().copy(request);
            }
        }, new Function<ListLoadBalancersResponse, String>(){

            public String apply(ListLoadBalancersResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListLoadBalancersRequest.Builder>, ListLoadBalancersRequest>(){

            public ListLoadBalancersRequest apply(RequestBuilderAndToken<ListLoadBalancersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListLoadBalancersRequest, ListLoadBalancersResponse>(){

            public ListLoadBalancersResponse apply(ListLoadBalancersRequest request) {
                return LoadBalancerPaginators.this.client.listLoadBalancers(request);
            }
        });
    }

    public Iterable<com.oracle.bmc.loadbalancer.model.LoadBalancer> listLoadBalancersRecordIterator(final ListLoadBalancersRequest request) {
        return new ResponseRecordIterable<ListLoadBalancersRequest.Builder, ListLoadBalancersRequest, ListLoadBalancersResponse, com.oracle.bmc.loadbalancer.model.LoadBalancer>(new Supplier<ListLoadBalancersRequest.Builder>(){

            public ListLoadBalancersRequest.Builder get() {
                return ListLoadBalancersRequest.builder().copy(request);
            }
        }, new Function<ListLoadBalancersResponse, String>(){

            public String apply(ListLoadBalancersResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListLoadBalancersRequest.Builder>, ListLoadBalancersRequest>(){

            public ListLoadBalancersRequest apply(RequestBuilderAndToken<ListLoadBalancersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListLoadBalancersRequest, ListLoadBalancersResponse>(){

            public ListLoadBalancersResponse apply(ListLoadBalancersRequest request) {
                return LoadBalancerPaginators.this.client.listLoadBalancers(request);
            }
        }, new Function<ListLoadBalancersResponse, List<com.oracle.bmc.loadbalancer.model.LoadBalancer>>(){

            public List<com.oracle.bmc.loadbalancer.model.LoadBalancer> apply(ListLoadBalancersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPoliciesResponse> listPoliciesResponseIterator(final ListPoliciesRequest request) {
        return new ResponseIterable<ListPoliciesRequest.Builder, ListPoliciesRequest, ListPoliciesResponse>(new Supplier<ListPoliciesRequest.Builder>(){

            public ListPoliciesRequest.Builder get() {
                return ListPoliciesRequest.builder().copy(request);
            }
        }, new Function<ListPoliciesResponse, String>(){

            public String apply(ListPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListPoliciesRequest.Builder>, ListPoliciesRequest>(){

            public ListPoliciesRequest apply(RequestBuilderAndToken<ListPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListPoliciesRequest, ListPoliciesResponse>(){

            public ListPoliciesResponse apply(ListPoliciesRequest request) {
                return LoadBalancerPaginators.this.client.listPolicies(request);
            }
        });
    }

    public Iterable<LoadBalancerPolicy> listPoliciesRecordIterator(final ListPoliciesRequest request) {
        return new ResponseRecordIterable<ListPoliciesRequest.Builder, ListPoliciesRequest, ListPoliciesResponse, LoadBalancerPolicy>(new Supplier<ListPoliciesRequest.Builder>(){

            public ListPoliciesRequest.Builder get() {
                return ListPoliciesRequest.builder().copy(request);
            }
        }, new Function<ListPoliciesResponse, String>(){

            public String apply(ListPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListPoliciesRequest.Builder>, ListPoliciesRequest>(){

            public ListPoliciesRequest apply(RequestBuilderAndToken<ListPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListPoliciesRequest, ListPoliciesResponse>(){

            public ListPoliciesResponse apply(ListPoliciesRequest request) {
                return LoadBalancerPaginators.this.client.listPolicies(request);
            }
        }, new Function<ListPoliciesResponse, List<LoadBalancerPolicy>>(){

            public List<LoadBalancerPolicy> apply(ListPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListProtocolsResponse> listProtocolsResponseIterator(final ListProtocolsRequest request) {
        return new ResponseIterable<ListProtocolsRequest.Builder, ListProtocolsRequest, ListProtocolsResponse>(new Supplier<ListProtocolsRequest.Builder>(){

            public ListProtocolsRequest.Builder get() {
                return ListProtocolsRequest.builder().copy(request);
            }
        }, new Function<ListProtocolsResponse, String>(){

            public String apply(ListProtocolsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListProtocolsRequest.Builder>, ListProtocolsRequest>(){

            public ListProtocolsRequest apply(RequestBuilderAndToken<ListProtocolsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListProtocolsRequest, ListProtocolsResponse>(){

            public ListProtocolsResponse apply(ListProtocolsRequest request) {
                return LoadBalancerPaginators.this.client.listProtocols(request);
            }
        });
    }

    public Iterable<LoadBalancerProtocol> listProtocolsRecordIterator(final ListProtocolsRequest request) {
        return new ResponseRecordIterable<ListProtocolsRequest.Builder, ListProtocolsRequest, ListProtocolsResponse, LoadBalancerProtocol>(new Supplier<ListProtocolsRequest.Builder>(){

            public ListProtocolsRequest.Builder get() {
                return ListProtocolsRequest.builder().copy(request);
            }
        }, new Function<ListProtocolsResponse, String>(){

            public String apply(ListProtocolsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListProtocolsRequest.Builder>, ListProtocolsRequest>(){

            public ListProtocolsRequest apply(RequestBuilderAndToken<ListProtocolsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListProtocolsRequest, ListProtocolsResponse>(){

            public ListProtocolsResponse apply(ListProtocolsRequest request) {
                return LoadBalancerPaginators.this.client.listProtocols(request);
            }
        }, new Function<ListProtocolsResponse, List<LoadBalancerProtocol>>(){

            public List<LoadBalancerProtocol> apply(ListProtocolsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListShapesResponse> listShapesResponseIterator(final ListShapesRequest request) {
        return new ResponseIterable<ListShapesRequest.Builder, ListShapesRequest, ListShapesResponse>(new Supplier<ListShapesRequest.Builder>(){

            public ListShapesRequest.Builder get() {
                return ListShapesRequest.builder().copy(request);
            }
        }, new Function<ListShapesResponse, String>(){

            public String apply(ListShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListShapesRequest.Builder>, ListShapesRequest>(){

            public ListShapesRequest apply(RequestBuilderAndToken<ListShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListShapesRequest, ListShapesResponse>(){

            public ListShapesResponse apply(ListShapesRequest request) {
                return LoadBalancerPaginators.this.client.listShapes(request);
            }
        });
    }

    public Iterable<LoadBalancerShape> listShapesRecordIterator(final ListShapesRequest request) {
        return new ResponseRecordIterable<ListShapesRequest.Builder, ListShapesRequest, ListShapesResponse, LoadBalancerShape>(new Supplier<ListShapesRequest.Builder>(){

            public ListShapesRequest.Builder get() {
                return ListShapesRequest.builder().copy(request);
            }
        }, new Function<ListShapesResponse, String>(){

            public String apply(ListShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListShapesRequest.Builder>, ListShapesRequest>(){

            public ListShapesRequest apply(RequestBuilderAndToken<ListShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListShapesRequest, ListShapesResponse>(){

            public ListShapesResponse apply(ListShapesRequest request) {
                return LoadBalancerPaginators.this.client.listShapes(request);
            }
        }, new Function<ListShapesResponse, List<LoadBalancerShape>>(){

            public List<LoadBalancerShape> apply(ListShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return LoadBalancerPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse, WorkRequest>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return LoadBalancerPaginators.this.client.listWorkRequests(request);
            }
        }, new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public LoadBalancerPaginators(LoadBalancer client) {
        this.client = client;
    }
}

