/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loadbalancer.model.PathRouteSet;
import com.oracle.bmc.loadbalancer.requests.ListPathRouteSetsRequest;
import com.oracle.bmc.loadbalancer.responses.ListPathRouteSetsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListPathRouteSetsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListPathRouteSetsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListPathRouteSetsRequest interceptRequest(ListPathRouteSetsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListPathRouteSetsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20170115").path("loadBalancers").path(HttpUtils.encodePathSegment(request.getLoadBalancerId())).path("pathRouteSets");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListPathRouteSetsResponse> fromResponse() {
        Function<Response, ListPathRouteSetsResponse> transformer = new Function<Response, ListPathRouteSetsResponse>(){

            public ListPathRouteSetsResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ListPathRouteSetsResponse");
                Function<Response, WithHeaders<List<PathRouteSet>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<PathRouteSet>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListPathRouteSetsResponse.Builder builder = ListPathRouteSetsResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListPathRouteSetsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

