/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HealthCheckResult {
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="sourceIpAddress")
    private final String sourceIpAddress;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="healthCheckStatus")
    private final HealthCheckStatus healthCheckStatus;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getSourceIpAddress() {
        return this.sourceIpAddress;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public HealthCheckStatus getHealthCheckStatus() {
        return this.healthCheckStatus;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HealthCheckResult)) {
            return false;
        }
        HealthCheckResult other = (HealthCheckResult)o;
        String this$subnetId = this.getSubnetId();
        String other$subnetId = other.getSubnetId();
        if (this$subnetId == null ? other$subnetId != null : !this$subnetId.equals(other$subnetId)) {
            return false;
        }
        String this$sourceIpAddress = this.getSourceIpAddress();
        String other$sourceIpAddress = other.getSourceIpAddress();
        if (this$sourceIpAddress == null ? other$sourceIpAddress != null : !this$sourceIpAddress.equals(other$sourceIpAddress)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        HealthCheckStatus this$healthCheckStatus = this.getHealthCheckStatus();
        HealthCheckStatus other$healthCheckStatus = other.getHealthCheckStatus();
        if (this$healthCheckStatus == null ? other$healthCheckStatus != null : !((Object)((Object)this$healthCheckStatus)).equals((Object)other$healthCheckStatus)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subnetId = this.getSubnetId();
        result = result * 59 + ($subnetId == null ? 43 : $subnetId.hashCode());
        String $sourceIpAddress = this.getSourceIpAddress();
        result = result * 59 + ($sourceIpAddress == null ? 43 : $sourceIpAddress.hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        HealthCheckStatus $healthCheckStatus = this.getHealthCheckStatus();
        result = result * 59 + ($healthCheckStatus == null ? 43 : ((Object)((Object)$healthCheckStatus)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "HealthCheckResult(subnetId=" + this.getSubnetId() + ", sourceIpAddress=" + this.getSourceIpAddress() + ", timestamp=" + this.getTimestamp() + ", healthCheckStatus=" + (Object)((Object)this.getHealthCheckStatus()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"subnetId", "sourceIpAddress", "timestamp", "healthCheckStatus"})
    @Deprecated
    public HealthCheckResult(String subnetId, String sourceIpAddress, Date timestamp, HealthCheckStatus healthCheckStatus) {
        this.subnetId = subnetId;
        this.sourceIpAddress = sourceIpAddress;
        this.timestamp = timestamp;
        this.healthCheckStatus = healthCheckStatus;
    }

    public static enum HealthCheckStatus {
        Ok("OK"),
        InvalidStatusCode("INVALID_STATUS_CODE"),
        TimedOut("TIMED_OUT"),
        RegexMismatch("REGEX_MISMATCH"),
        ConnectFailed("CONNECT_FAILED"),
        IoError("IO_ERROR"),
        Offline("OFFLINE"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, HealthCheckStatus> map;

        private HealthCheckStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static HealthCheckStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'HealthCheckStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(HealthCheckStatus.class);
            map = new HashMap<String, HealthCheckStatus>();
            for (HealthCheckStatus v : HealthCheckStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="sourceIpAddress")
        private String sourceIpAddress;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="healthCheckStatus")
        private HealthCheckStatus healthCheckStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder sourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
            this.__explicitlySet__.add("sourceIpAddress");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder healthCheckStatus(HealthCheckStatus healthCheckStatus) {
            this.healthCheckStatus = healthCheckStatus;
            this.__explicitlySet__.add("healthCheckStatus");
            return this;
        }

        public HealthCheckResult build() {
            HealthCheckResult __instance__ = new HealthCheckResult(this.subnetId, this.sourceIpAddress, this.timestamp, this.healthCheckStatus);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(HealthCheckResult o) {
            Builder copiedBuilder = this.subnetId(o.getSubnetId()).sourceIpAddress(o.getSourceIpAddress()).timestamp(o.getTimestamp()).healthCheckStatus(o.getHealthCheckStatus());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

