/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loadbalancer.model.WorkRequestError;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequest {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="loadBalancerId")
    private final String loadBalancerId;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="errorDetails")
    private final List<WorkRequestError> errorDetails;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getType() {
        return this.type;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public List<WorkRequestError> getErrorDetails() {
        return this.errorDetails;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkRequest)) {
            return false;
        }
        WorkRequest other = (WorkRequest)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$loadBalancerId = this.getLoadBalancerId();
        String other$loadBalancerId = other.getLoadBalancerId();
        if (this$loadBalancerId == null ? other$loadBalancerId != null : !this$loadBalancerId.equals(other$loadBalancerId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Date this$timeAccepted = this.getTimeAccepted();
        Date other$timeAccepted = other.getTimeAccepted();
        if (this$timeAccepted == null ? other$timeAccepted != null : !((Object)this$timeAccepted).equals(other$timeAccepted)) {
            return false;
        }
        Date this$timeFinished = this.getTimeFinished();
        Date other$timeFinished = other.getTimeFinished();
        if (this$timeFinished == null ? other$timeFinished != null : !((Object)this$timeFinished).equals(other$timeFinished)) {
            return false;
        }
        List<WorkRequestError> this$errorDetails = this.getErrorDetails();
        List<WorkRequestError> other$errorDetails = other.getErrorDetails();
        if (this$errorDetails == null ? other$errorDetails != null : !((Object)this$errorDetails).equals(other$errorDetails)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $loadBalancerId = this.getLoadBalancerId();
        result = result * 59 + ($loadBalancerId == null ? 43 : $loadBalancerId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Date $timeAccepted = this.getTimeAccepted();
        result = result * 59 + ($timeAccepted == null ? 43 : ((Object)$timeAccepted).hashCode());
        Date $timeFinished = this.getTimeFinished();
        result = result * 59 + ($timeFinished == null ? 43 : ((Object)$timeFinished).hashCode());
        List<WorkRequestError> $errorDetails = this.getErrorDetails();
        result = result * 59 + ($errorDetails == null ? 43 : ((Object)$errorDetails).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "WorkRequest(id=" + this.getId() + ", loadBalancerId=" + this.getLoadBalancerId() + ", type=" + this.getType() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", message=" + this.getMessage() + ", timeAccepted=" + this.getTimeAccepted() + ", timeFinished=" + this.getTimeFinished() + ", errorDetails=" + this.getErrorDetails() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "loadBalancerId", "type", "lifecycleState", "message", "timeAccepted", "timeFinished", "errorDetails"})
    @Deprecated
    public WorkRequest(String id, String loadBalancerId, String type, LifecycleState lifecycleState, String message, Date timeAccepted, Date timeFinished, List<WorkRequestError> errorDetails) {
        this.id = id;
        this.loadBalancerId = loadBalancerId;
        this.type = type;
        this.lifecycleState = lifecycleState;
        this.message = message;
        this.timeAccepted = timeAccepted;
        this.timeFinished = timeFinished;
        this.errorDetails = errorDetails;
    }

    public static enum LifecycleState {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Failed("FAILED"),
        Succeeded("SUCCEEDED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="loadBalancerId")
        private String loadBalancerId;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="errorDetails")
        private List<WorkRequestError> errorDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            this.__explicitlySet__.add("loadBalancerId");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder errorDetails(List<WorkRequestError> errorDetails) {
            this.errorDetails = errorDetails;
            this.__explicitlySet__.add("errorDetails");
            return this;
        }

        public WorkRequest build() {
            WorkRequest __instance__ = new WorkRequest(this.id, this.loadBalancerId, this.type, this.lifecycleState, this.message, this.timeAccepted, this.timeFinished, this.errorDetails);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(WorkRequest o) {
            Builder copiedBuilder = this.id(o.getId()).loadBalancerId(o.getLoadBalancerId()).type(o.getType()).lifecycleState(o.getLifecycleState()).message(o.getMessage()).timeAccepted(o.getTimeAccepted()).timeFinished(o.getTimeFinished()).errorDetails(o.getErrorDetails());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

