/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.loadbalancer.model.CreateBackendSetDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateBackendSetRequest
extends BmcRequest {
    private CreateBackendSetDetails createBackendSetDetails;
    private String loadBalancerId;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"createBackendSetDetails", "loadBalancerId", "opcRequestId", "opcRetryToken"})
    CreateBackendSetRequest(CreateBackendSetDetails createBackendSetDetails, String loadBalancerId, String opcRequestId, String opcRetryToken) {
        this.createBackendSetDetails = createBackendSetDetails;
        this.loadBalancerId = loadBalancerId;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateBackendSetDetails getCreateBackendSetDetails() {
        return this.createBackendSetDetails;
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateBackendSetDetails createBackendSetDetails;
        private String loadBalancerId;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateBackendSetRequest o) {
            this.createBackendSetDetails(o.getCreateBackendSetDetails());
            this.loadBalancerId(o.getLoadBalancerId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateBackendSetRequest build() {
            CreateBackendSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createBackendSetDetails(CreateBackendSetDetails createBackendSetDetails) {
            this.createBackendSetDetails = createBackendSetDetails;
            return this;
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateBackendSetRequest buildWithoutInvocationCallback() {
            return new CreateBackendSetRequest(this.createBackendSetDetails, this.loadBalancerId, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateBackendSetRequest.Builder(createBackendSetDetails=" + this.createBackendSetDetails + ", loadBalancerId=" + this.loadBalancerId + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

