/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.loadbalancer.model.CreateLoadBalancerDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateLoadBalancerRequest
extends BmcRequest {
    private CreateLoadBalancerDetails createLoadBalancerDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"createLoadBalancerDetails", "opcRequestId", "opcRetryToken"})
    CreateLoadBalancerRequest(CreateLoadBalancerDetails createLoadBalancerDetails, String opcRequestId, String opcRetryToken) {
        this.createLoadBalancerDetails = createLoadBalancerDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateLoadBalancerDetails getCreateLoadBalancerDetails() {
        return this.createLoadBalancerDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateLoadBalancerDetails createLoadBalancerDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateLoadBalancerRequest o) {
            this.createLoadBalancerDetails(o.getCreateLoadBalancerDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateLoadBalancerRequest build() {
            CreateLoadBalancerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createLoadBalancerDetails(CreateLoadBalancerDetails createLoadBalancerDetails) {
            this.createLoadBalancerDetails = createLoadBalancerDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateLoadBalancerRequest buildWithoutInvocationCallback() {
            return new CreateLoadBalancerRequest(this.createLoadBalancerDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateLoadBalancerRequest.Builder(createLoadBalancerDetails=" + this.createLoadBalancerDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

