/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.loadbalancer.model.CreateRuleSetDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateRuleSetRequest
extends BmcRequest {
    private String loadBalancerId;
    private CreateRuleSetDetails createRuleSetDetails;
    private String opcRequestId;

    @ConstructorProperties(value={"loadBalancerId", "createRuleSetDetails", "opcRequestId"})
    CreateRuleSetRequest(String loadBalancerId, CreateRuleSetDetails createRuleSetDetails, String opcRequestId) {
        this.loadBalancerId = loadBalancerId;
        this.createRuleSetDetails = createRuleSetDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public CreateRuleSetDetails getCreateRuleSetDetails() {
        return this.createRuleSetDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String loadBalancerId;
        private CreateRuleSetDetails createRuleSetDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateRuleSetRequest o) {
            this.loadBalancerId(o.getLoadBalancerId());
            this.createRuleSetDetails(o.getCreateRuleSetDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateRuleSetRequest build() {
            CreateRuleSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder createRuleSetDetails(CreateRuleSetDetails createRuleSetDetails) {
            this.createRuleSetDetails = createRuleSetDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateRuleSetRequest buildWithoutInvocationCallback() {
            return new CreateRuleSetRequest(this.loadBalancerId, this.createRuleSetDetails, this.opcRequestId);
        }

        public String toString() {
            return "CreateRuleSetRequest.Builder(loadBalancerId=" + this.loadBalancerId + ", createRuleSetDetails=" + this.createRuleSetDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

