/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteRuleSetRequest
extends BmcRequest {
    private String loadBalancerId;
    private String ruleSetName;
    private String opcRequestId;

    @ConstructorProperties(value={"loadBalancerId", "ruleSetName", "opcRequestId"})
    DeleteRuleSetRequest(String loadBalancerId, String ruleSetName, String opcRequestId) {
        this.loadBalancerId = loadBalancerId;
        this.ruleSetName = ruleSetName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getRuleSetName() {
        return this.ruleSetName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String loadBalancerId;
        private String ruleSetName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteRuleSetRequest o) {
            this.loadBalancerId(o.getLoadBalancerId());
            this.ruleSetName(o.getRuleSetName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteRuleSetRequest build() {
            DeleteRuleSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteRuleSetRequest buildWithoutInvocationCallback() {
            return new DeleteRuleSetRequest(this.loadBalancerId, this.ruleSetName, this.opcRequestId);
        }

        public String toString() {
            return "DeleteRuleSetRequest.Builder(loadBalancerId=" + this.loadBalancerId + ", ruleSetName=" + this.ruleSetName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

