/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPathRouteSetRequest
extends BmcRequest {
    private String loadBalancerId;
    private String pathRouteSetName;
    private String opcRequestId;

    @ConstructorProperties(value={"loadBalancerId", "pathRouteSetName", "opcRequestId"})
    GetPathRouteSetRequest(String loadBalancerId, String pathRouteSetName, String opcRequestId) {
        this.loadBalancerId = loadBalancerId;
        this.pathRouteSetName = pathRouteSetName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getPathRouteSetName() {
        return this.pathRouteSetName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String loadBalancerId;
        private String pathRouteSetName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPathRouteSetRequest o) {
            this.loadBalancerId(o.getLoadBalancerId());
            this.pathRouteSetName(o.getPathRouteSetName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPathRouteSetRequest build() {
            GetPathRouteSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder pathRouteSetName(String pathRouteSetName) {
            this.pathRouteSetName = pathRouteSetName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetPathRouteSetRequest buildWithoutInvocationCallback() {
            return new GetPathRouteSetRequest(this.loadBalancerId, this.pathRouteSetName, this.opcRequestId);
        }

        public String toString() {
            return "GetPathRouteSetRequest.Builder(loadBalancerId=" + this.loadBalancerId + ", pathRouteSetName=" + this.pathRouteSetName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

